package cn.freemud.management.entities.dto.request.order;

import cn.freemud.management.enums.OperateType;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Size;

@Data
public class OrderManagerRequest {
    /**
     * 商户号
     */
    @NotEmpty(message = "商户号不允许为null")
    private String partnerId;

    /**
     * 门店号
     */
    private String storeId;

    /**
     * 订单号
     */
    @NotEmpty(message = "订单号不允许为nul")
    private String orderId;

    /**
     * 退款原因
     */
    @Size(max=50,message = "原因不能超过50个字符")
    private String reason;

    /**
     * 退款原因code
     * 用于平台外卖（美团、饿了么）
     */
    private Integer reason_code;

    /**
     * 订单操作类型
     * @see OperateType
     */
    @NotEmpty(message = "操作类型不能为空")
    private String operateType;

    /**
     * 操作人
     * pos
     * 开放平台
     * 小助手
     * 系统自动履单
     */
    @NotEmpty(message = "操作人不能为空")
    private String operator;

    /**
     * 取餐码
     * 麦咖啡专用
     */
    private String pickUpGoodsNo;

    private String remark;
    private Boolean horseman;

    /**
     * 派单模式(0-系统自动派单;1-手动派单)
     * 内置传参使用
     */
    private String dispatchType;

    /**
     * 半自动派单时间 (分钟)
     */
    private Integer dispatchTimeout;

    /**
     * 内部使用字段, 订单流转时间设置
     */
    private Integer timeout;

    /**
     * 售后渠道 1:POS插件 2:小助手 3:开放平台 4:自动任务 5:用户端 6:系统 7:万象 8:太一 9:订单宝
     */
    private Integer operationClient;

    /**
     * 品牌审核售后单　不传默认无需品牌审核
     */
    private Boolean brandVerifyAfterSales = false;

    /**
     * 部分退金额，单位分
     */
    private Integer refundAmount;
}
