package cn.freemud.management.entities.dto.request.coupon;

import lombok.Data;
import org.springframework.lang.Nullable;


/**
 * &copy; All rights Reserved, Designed By www.freemud.cn
 *
 * @author wénkǎi.zhāng 2023-05-30
 * @since 1.0
 */
@Data
public class CodeInfoQueryDto {
    /**
     * 券名称
     */
    private String name;

    /**
     * 券号,目前最长23个字符
     */
    private String code;

    /**
     * 券Logo
     */
    private String logo;

    /**
     * 券类型
     */
    private Integer type;

    /**
     * 券状态：0可用，1已核销，2部分核销
     */
    private Integer state;

    /**
     * 当前剩余可用次数
     */
    private Integer leftAvailableTimes;

    /**
     * 最大剩余可用次数
     */
    private Integer maxLeftAvailableTimes;


    /**
     * 优惠券使用限制相关配置
     */
    private CouponCodeUseRuleModel couponUseRule;

    @Data
    public static class CouponCodeUseRuleModel {
        /**
         * 最大可核销次数，大于1时为频次券， 默认1次
         */
        private int maxRedeemTimes = 1;

        /**
         * 核销次数限制类型对应的可核销次数，频次券时有效，默认null不限
         */
        @Nullable
        private Integer limitedRedeemTimes;
    }

}
