/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/11 19:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.store.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "CONSOLE-API",url="${saas.storeclient.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface StoreClient {

    /**
     * 查询门店信息
     */
    @LogIgnoreFeign(logMessage="getStoreMix",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/api/v2/organization/getStoreMix", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    StoreBaseResponseDto<StoreMixResponseDto> getStoreInfoNew(@RequestBody StoreInfoRequestDto request);

    /**
     * 查询门店信息
     */
    @LogIgnoreFeign(logMessage="getListByCodes",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/storecenter/store/v2/getListByCodes", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    StoreBaseResponseDto<StoreListResponse> getListByCodes(@RequestBody GetStoreListbyCodesRequest request);
}
