package cn.freemud.interceptor;

import cn.freemud.enums.CommonResponseResult;
import com.freemud.application.sdk.api.exception.IgnoreErrorAnnotation;

/**
 * 自定义服务异常抛出
 * message 错误信息
 */
@SuppressWarnings("serial")
@IgnoreErrorAnnotation
public class CommonServiceException extends RuntimeException {

    private CommonResponseResult result;

    private String message;

    public CommonServiceException(CommonResponseResult result) {
        this.result = result;
        this.message = result.getMessage();
    }

    public CommonServiceException(CommonResponseResult result, String message) {
        this.result = result;
        this.message = message;
    }

    public CommonResponseResult getResult() {
        return result;
    }

    public void setResult(CommonResponseResult result) {
        this.result = result;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
