/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import com.freemud.application.sdk.api.ordercenter.enums.RefundModeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 退款预校验参数
 *
 * @author haibo.jiang 2019/11/20
 * @author shichang.wang 2021/4/15
 */
@ApiModel("退款预校验参数")
@Data
public class PreValidRefundReq {

    @NotBlank(message = "商户号为空")
    private String partnerId;

    @NotBlank(message = "订单号为空")
    private String orderCode;

    /**
     * 微商城退款方式
     *
     * @see RefundModeEnum#getIndex()
     */
    @ApiModelProperty(value = "微商城退款方式", notes = RefundModeEnum.API_DOC)
    private Byte refundMode;
}
