package com.freemud.sdk.api.assortment.order.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: NewOldOrderType
 * @Package com.freemud.sdk.api.assortment.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/18 17:28
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum NewOrderType {

    GENERAL_DINE_IN(1, "店内自取实时-1常规堂食"),
    RESERVED_DINE_IN(2, "店内自取预约-2预约堂食"),
    GENERAL_EXPRESS(3, "店外快递实时-3常规外送"),
    RESERVED_EXPRESS(4, "店外快递预约-4预约外送"),
    GENERAL_SELF_PICKUP(5, "店外自取实时-5常规自取"),
    RESERVED_SELF_PICKUP(6, "店外自取预约-6预约自取")
    ;

    private final Integer code;
    private final String desc;

    NewOrderType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<Integer> getAllCodes() {
        List<Integer> list = new ArrayList<>();
        for (NewOrderType type : values()) {
            list.add(type.getCode());
        }
        return list;
    }


    public static NewOrderType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (NewOrderType newOrderType : values()) {
            if (newOrderType.getCode().equals(code)) {
                return newOrderType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isDelivery(Integer orderType) {
        if (orderType == null) {
            return false;
        }
        return orderType.equals(NewOrderType.GENERAL_EXPRESS.getCode())
                || orderType.equals(NewOrderType.RESERVED_EXPRESS.getCode());
    }

}
