package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author yuanyuan.jing  2018/12/14 18:28
 */
@Data
@ApiModel(description = "申请退款请求")
public class RefundByTransactionCodeRequest {
    @ApiModelProperty(value = "接口版本，必须为2", position = 1)
    private String ver;

    @ApiModelProperty(value = "当前交易的唯一标识", required = true)
    @NotNull
    private Long paymentId;

    @ApiModelProperty(value = "商户编号（由非码提供）", required = true)
    @NotNull
    private String partnerId;

    @ApiModelProperty(value = "商家门店号（在线支付需要提前定义）", required = true)
    @NotNull
    private String storeId;

    @ApiModelProperty(value = "外部退款交易序号（作为每笔退款唯一标识）", required = true)
    @NotNull
    private String frontRefundId;

    /**
     * 非码交易流水
     */
    @ApiModelProperty(value = "非码交易流水")
    private String transactionCode;

    @ApiModelProperty(value = "退款金额", position = 11)
    @NotNull
    private Long refundAmount;

    @ApiModelProperty(value = "退款原因描述", position = 12)
    private String refundDesc;

    @ApiModelProperty(value = "退款操作人", position = 14)
    private String operatorName;
}
