/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CollageOrderServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: hui.miao
 * @date: 2020/10/11 20:55
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;


import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.wechat.GroupBuyResp;
import com.freemud.sdk.api.assortment.order.response.order.GroupBuyResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.WechatGroupBuyVo;
import cn.freemud.enums.OrderMarketType;
import cn.freemud.service.CollageOrderService;
import cn.freemud.utils.ResponseUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class CollageOrderServiceImpl implements CollageOrderService {
    @Autowired
    private OrderServiceImpl orderService;

    /**
     * 创建拼单订单
     */
    @Override
    public BaseResponse create(CreateOrderVo createOrderVo) {
        // 标记订单类型-4 拼单
        createOrderVo.setMarketingType(OrderMarketType.COLLAGE.getIndex());
        return this.orderService.createOrderNew(createOrderVo);
    }

    /**
     * 创建群收款
     * @param requestVo
     * @return
     */
    @Override
    public BaseResponse createGroupBuy(WechatGroupBuyVo requestVo) {
        GroupBuyResp groupBuyResp = new GroupBuyResp();
        groupBuyResp.setGroupBuyOrderId("AARwDhsBAAABAAAAAAA8qP8oA4wVBRDgTYemXSAAAAC+NhafsoPlHq4RjEYubHs/qZzK7T9Q 02qG5CNcaTRRAyNIF/DIBcbFQuBKJTnEezsaW1SDpyM9G6MNK9T2wzeWQlajckiSTDZDWjAn9O1 WASuHkIZdf9SRQrIAwZdwjsBf7MPxtQP/4ExaW0B9g9IG");
        return ResponseUtil.success(groupBuyResp);
    }
}
