package cn.freemud.fuyou.service.processor;

import cn.freemud.enums.PayChannelEnum;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.service.PaymentService;
import com.freemud.application.sdk.api.ordercenter.enums.OrderSettlementType;
import com.freemud.application.sdk.api.ordercenter.request.OrderSettlementReq;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import static cn.freemud.management.util.ResponseCodeEnum.SUCCESS;


/**
 * 现金支付
 */
@Component
@Slf4j
public class CashEventProcessor extends AbstractProcessor {


    protected CashEventProcessor(OrderSdkService orderSdkService, PaymentService paymentService) {
        super(orderSdkService, paymentService);
    }

    @Override
    BaseResponse doProcess(DiscountRequest request) {
        BaseResponse baseResponse =new BaseResponse();
        baseResponse.setCode(SUCCESS.code);
        return baseResponse;
    }

    public OrderInfoReqs getOrderByThirdOrderCode(String thirdOrderCode, String orderClient) {
        return super.getOrderByThirdOrderCode(thirdOrderCode, orderClient);
    }

    @Override
    OrderSettlementReq getOrderSettlement(DiscountRequest request) {
        OrderInfoReqs orderInfoReqs = request.getOrderInfoReqs();
        return buildOrderSettlement("现金支付", OrderSettlementType.CASH, false, orderInfoReqs, request);
    }

    @Override
    public Integer getEvent() {
        return PayChannelEnum.CASH.getCode();
    }

}
