package cn.freemud.controller.test;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.wechat.GetAuthorizerRequestDto;
import cn.freemud.entities.dto.wechat.GetTokenResponseDto;
import cn.freemud.service.thirdparty.EcologyAdminApplicationClient;
import cn.freemud.service.thirdparty.WeChatClient;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import com.freemud.sdk.api.assortment.order.request.order.GroupBuyRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.controller
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/7/8
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Slf4j
@RequestMapping("/order")
@RestController
@Validated
public class TestController {

    @Autowired
    private EcologyAdminApplicationClient ecologyAdminApplicationClient;
    @Autowired
    private WeChatClient weChatClient;

    @ApiAnnotation(logMessage = "orderStatusChange")
    @PostMapping("/orderStatusChange")
    public PlatformBaseResponse orderStatusChange(@Validated @LogParams @RequestBody PlatformBaseRequest checkBeforeCreateOrderRequestVo) {
        PlatformBaseResponse platformBaseResponse = new PlatformBaseResponse();
        platformBaseResponse.setStatusCode("100");
        return platformBaseResponse;
    }

    @ApiAnnotation(logMessage = "refundStatusChange")
    @PostMapping("/refundStatusChange")
    public PlatformBaseResponse refundStatusChange(@Validated @LogParams @RequestBody PlatformBaseRequest checkBeforeCreateOrderRequestVo) {
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        PlatformBaseResponse platformBaseResponse = new PlatformBaseResponse();
        platformBaseResponse.setStatusCode("100");
        return platformBaseResponse;
    }

    @ApiAnnotation(logMessage = "testOrderDelivery")
    @PostMapping("/testOrderDelivery")
    public PlatformBaseResponse testOrderDelivery(@Validated @LogParams @RequestBody PlatformBaseRequest platformBaseRequest) {
        PlatformBaseResponse platformBaseResponse = new PlatformBaseResponse();
        platformBaseResponse.setStatusCode("100");
        log.info("testOrderDelivery get {}",JSONObject.toJSONString(platformBaseRequest));
        return platformBaseResponse;
    }

    @GetMapping("/test/groupBuy")
    public BaseResponse testOrderDelivery() {
        String partnerId = "1864";
        String appId = "wxb78fb7c6218cb52c";
        GetAuthorizerRequestDto getAuthorizerRequestDto = new GetAuthorizerRequestDto();
        getAuthorizerRequestDto.setPartnerId(partnerId);
        getAuthorizerRequestDto.setAuthorizerAppid(appId);
        GetTokenResponseDto getTokenResponseDto = ecologyAdminApplicationClient.getAuthorizerAccessToken(getAuthorizerRequestDto);

        String accessToken = getTokenResponseDto.getResult().getAccessToken();
        log.info("token:{}", accessToken);

        GroupBuyRequest groupBuyRequest = new GroupBuyRequest();
        groupBuyRequest.setOut_trade_no("88888888");
        groupBuyRequest.setRecv_openid("oORZK5NUo7sDvuJwPwbehqq360Tw");
        groupBuyRequest.setScene(1);

        // pay_list
        GroupBuyRequest.PayList payList = new GroupBuyRequest.PayList();
        List<GroupBuyRequest.UserInfo> userInfoList = new ArrayList<>();

        GroupBuyRequest.UserInfo userInfo1 = new GroupBuyRequest.UserInfo();
        userInfo1.setOpenid("oORZK5A8hrejg0uBVSlkpv-KPgv4");
        userInfo1.setAmount(1);
        userInfoList.add(userInfo1);
//        GroupBuyRequest.UserInfo userInfo2 = new GroupBuyRequest.UserInfo();
//        userInfo2.setOpenid("ohvIM0VbQw41wCznsgYHu7W6W_bA");
//        userInfo2.setAmount(2);
//        userInfoList.add(userInfo2);
//        GroupBuyRequest.UserInfo userInfo3 = new GroupBuyRequest.UserInfo();
//        userInfo3.setOpenid("oORZK5MHMBm78PO302NdRyzIY5K0");
//        userInfo3.setAmount(3);
//        userInfoList.add(userInfo2);


        payList.setUser_info(userInfoList);
        groupBuyRequest.setPay_list(payList);

        // desc
        GroupBuyRequest.Desc desc = new GroupBuyRequest.Desc();
        desc.setText_desc("非码商户 20201128");

        //String requestUrl = "https://api.weixin.qq.com/wxa/business/groupBuy/createOrder?access_token=" + accessToken;

        String result = weChatClient.groupBuyCreateOrder(accessToken, groupBuyRequest);

        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setResult(result);
        log.info("response:{}",JSONObject.toJSONString(baseResponse));
        return baseResponse;
    }
}
