package cn.freemud.service.mccafe.impl;

import cn.freemud.adapter.CouponAdapter;
import cn.freemud.adapter.OrderAdapter;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.management.entities.dto.request.order.*;
import cn.freemud.enums.CouponReqTypeEnum;
import cn.freemud.enums.MCCafeChannelEnum;
import cn.freemud.management.entities.dto.response.coupon.McdNetBatchQueryResponse;
import cn.freemud.management.enums.OrderSource;
import cn.freemud.management.thirdparty.CouponOfflineMCCafeClient;
import cn.freemud.service.mccafe.CouponClientService;
import cn.freemud.utils.AppLogUtil;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.application.sdk.api.couponcenter.offline.service.OfflineCouponSdkService;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.service.EmailAlertService;
import com.freemud.sdk.api.assortment.order.enums.*;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class CouponClientServiceImpl implements CouponClientService {

    @Autowired
    private CouponOfflineMCCafeClient couponOfflineMCCafeClient;

    @Autowired
    private CouponAdapter couponAdapter;

    @Autowired
    private OrderAdapter orderAdapter;

    @Autowired
    private OfflineCouponSdkService offlineCouponSdkService;

    @Autowired
    private EmailAlertService emailAlertService;

    @Override
    public CouponRedeemResponse redeem(MCCafeCouponRequest mcCafeCouponRequest) {
        return couponOfflineMCCafeClient.redeem(mcCafeCouponRequest);
    }

    @Override
    public List<CouponRedeemResponse> redeemBatch(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
        if (null == orderBean || CollectionUtils.isEmpty(orderBean.getAccountList())) {
            return null;
        }
        List<QueryOrdersResponseDto.DataBean.OrderBean.AccountBean> accountList = orderBean.getAccountList().stream().filter(
                account -> (OldOrderAccountType.COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.PRODUCT_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.EVM_PRODUCT_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.B3S1_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.DISCOUNT_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.FREIGHT_COUPON.getCode().equals(account.getType()))
        ).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountList)) {
            return null;
        }

        MCCafeCouponRequest mcCafeCouponRequest = MCCafeCouponRequest.builder()
                .ver(88)
                .reqtype(CouponReqTypeEnum.BATCH_QUERY.getCode())
                .partnerId(Integer.parseInt(orderBean.getCompanyId()))
                .store_id(orderBean.getShopId())
                .station_id("1")
                .operator_id(orderBean.getUserId())
                .channel(OrderSource.ALIPAY.getSource().equals(orderBean.getSource())?MCCafeChannelEnum.MOCOFFEE_ZFB.getName():MCCafeChannelEnum.MOCOFFEE_WX.getName())
                .couponlist(accountList.stream().map(o -> new MCCafeCouponVo(o.getAccountId())).collect(Collectors.toList()))
                .sign("skip")
                .build();
        McdNetBatchQueryResponse mcdNetBatchQueryResponse = batchQuery(mcCafeCouponRequest);
        if (mcdNetBatchQueryResponse == null || !ResponseCodeConstant.RESPONSE_SUCCESS.equals(mcdNetBatchQueryResponse.getStatusCode())
                || CollectionUtils.isEmpty(mcdNetBatchQueryResponse.getCouponlist())) {
//            AppLogUtil.errorLog("获取优惠券详情失败，无法核销", mcCafeCouponRequest, mcdNetBatchQueryResponse);
            return null;
        }

        Map<String, McdNetBatchQueryResponse.Coupon> couponMap = mcdNetBatchQueryResponse.getCouponlist().stream()
                .collect(Collectors.toMap(McdNetBatchQueryResponse.Coupon::getCode, Function.identity(), (k1, k2) -> k1));

        List<MCCafeCouponRequest> list =
                accountList.stream().map(accountBean -> couponAdapter.convert2MCCafeCouponRequest(orderBean, accountBean, couponMap.get(accountBean.getAccountId()))).filter(o -> o!=null).collect(Collectors.toList());

        List<CouponRedeemResponse> couponRedeemResponseList = new ArrayList<>();
        List<CouponRedeemResponse> couponRedeemResponseListAll = new ArrayList<>();
        redeem:
        for (MCCafeCouponRequest request : list) {
            CouponRedeemResponse couponRedeemResponse = null;
            retry:
            for(int i=0;i<3;i++) {
                couponRedeemResponse = redeem(request);
                if(ResponseCodeConstant.RESPONSE_SUCCESS.equals(couponRedeemResponse.getStatusCode())) {
                    couponRedeemResponseListAll.add(couponRedeemResponse);
                    continue redeem;
                }
            }
            couponRedeemResponseList.add(couponRedeemResponse);
            couponRedeemResponseListAll.add(couponRedeemResponse);
        }
//        if(CollectionUtils.isNotEmpty(couponRedeemResponseList)) {
//            AppLogUtil.infoLog(LogThreadLocal.getTrackingNo(), "麦咖啡核销券失败",
//                    JSON.toJSONString(list), JSON.toJSONString(couponRedeemResponseListAll));
//        }

        return couponRedeemResponseList;
    }
    @Override
    public McdNetBatchQueryResponse batchQuery(MCCafeCouponRequest mcCafeCouponRequest) {
        return couponOfflineMCCafeClient.batchQuery(mcCafeCouponRequest);
    }

    @Override
    public CouponBaseResponse lock(MCCafeCouponLockRequest mcCafeCouponLockRequest) {
        return couponOfflineMCCafeClient.lock(mcCafeCouponLockRequest);
    }

    @Override
    public List<CouponBaseResponse> lockBatch(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
        if (null == orderBean || CollectionUtils.isEmpty(orderBean.getAccountList())) {
            return null;
        }
        List<QueryOrdersResponseDto.DataBean.OrderBean.AccountBean> accountList = orderBean.getAccountList().stream().filter(
                account -> (OldOrderAccountType.PRODUCT_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.EVM_PRODUCT_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.B3S1_COUPON.getCode().equals(account.getType())
                        || OldOrderAccountType.DISCOUNT_COUPON.getCode().equals(account.getType())
                        )).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountList)) {
            return null;
        }

        List<MCCafeCouponLockRequest> list =
                accountList.stream().map(accountBean -> couponAdapter.convert2MCCafeCouponLockRequest(orderBean, accountBean)).collect(Collectors.toList());

        List<CouponBaseResponse> baseResponseList = new ArrayList<>();
        List<CouponBaseResponse> baseResponseListAll = new ArrayList<>();
        lock:
        for (MCCafeCouponLockRequest request : list) {
            CouponBaseResponse baseResponse = null;
            retry:
            for(int i=0;i<3;i++) {
                baseResponse = lock(request);
                if(ResponseCodeConstant.RESPONSE_SUCCESS.equals(baseResponse.getStatusCode())) {
                    baseResponseListAll.add(baseResponse);
                    continue lock;
                }
            }
            baseResponseList.add(baseResponse);
            baseResponseListAll.add(baseResponse);
        }

        if(CollectionUtils.isNotEmpty(baseResponseList)) {
            AppLogUtil.infoLog(LogThreadLocal.getTrackingNo(), "麦咖啡冻结券失败",
                    JSON.toJSONString(list), JSON.toJSONString(baseResponseListAll));
        }

        return baseResponseList;
    }
}
