package cn.freemud.manager;

import cn.freemud.entities.db.Partner;
import cn.freemud.entities.db.PushMccafeOrder;
import cn.freemud.manager.dao.PartnerDao;
import cn.freemud.manager.dao.PushMccafeOrderDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 商户小程序manager
 *
 * @author liming.guo
 * @date 2018/05/10
 */
@Component
public class PushMccafeOrderManager {

    @Autowired
    private PushMccafeOrderDao pushMccafeOrderDao;

    public PushMccafeOrder selectOrder(String orderCode) {
        return pushMccafeOrderDao.selectOrder(orderCode);
    }

    public List<PushMccafeOrder> selectOrderByStatus(Integer id) {
        return pushMccafeOrderDao.selectOrderByStatus(id);
    }

    public Integer insertOrder(PushMccafeOrder pushMccafeOrder) {
        return pushMccafeOrderDao.insertOrder(pushMccafeOrder);
    }

    public Integer updateOrder(PushMccafeOrder pushMccafeOrder) {
        return pushMccafeOrderDao.updateOrder(pushMccafeOrder);
    }

}
