package cn.freemud.demo.manager.product;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.demo.ValidateShopProductRequestBO;
import cn.freemud.demo.adapter.manager.ProductBO2DTOAdapter;
import cn.freemud.demo.adapter.manager.ProductDTO2BOAdapter;
import cn.freemud.demo.entities.GetProductBySkuIdBO;
import cn.freemud.demo.entities.GetProductStock;
import cn.freemud.demo.entities.ProductStockBO;
import cn.freemud.demo.entities.ValiadShopProductBO;
import cn.freemud.demo.entities.bo.goods.GetProductBO;
import cn.freemud.demo.entities.bo.goods.GetProductBySkuIdResponseBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import cn.freemud.entities.vo.GetProductsVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.ItemService;
import cn.freemud.service.impl.AssortmentSdkService;
import cn.freemud.service.thirdparty.StockClient;
import cn.freemud.service.thirdparty.StoreItemClient;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductRequest;
import com.freemud.application.sdk.api.productcenter.response.ProductResponseDTO;
import com.freemud.application.sdk.api.productcenter.response.valid.ValiadShopProductResponse;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("KgdProductService")
public class KgdProductServiceImpl implements ProductService {


    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ProductDTO2BOAdapter productDTO2BOAdapter;

    @Autowired
    private ProductBO2DTOAdapter productBO2DTOAdapter;


    @Autowired
    private ItemService itemService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    @Autowired
    private StockClient stockClient;

    @Autowired
    private StoreItemClient storeItemClient;

    @Override
    public List<ProductBO> getProductInfo(GetProductBO getProductBO) {
        // 获取添加商品的详细信息
        List<ProductBeanDTO> productBeanListSpuClass = assortmentSdkService.getProductsInfoSdk(getProductBO.getPartnerId(),
                        getProductBO.getStoreId(), getProductBO.getSpuid(), getProductBO.getMenuType(), shoppingCartBaseService);

        List<ProductBO> productList = new ArrayList<>();
        for (ProductBeanDTO dto : productBeanListSpuClass){
            ProductBO platformProductBO = productDTO2BOAdapter.convert2ProductBO(dto);
            productList.add(platformProductBO);
        }
        return productList;
    }

    @Override
    public Map<String, GetProductBySkuIdResponseBO> getProductInfoBySkuIds(GetProductBySkuIdBO getProductBySkuIdBO) {

        Map<String, GetProductBySkuIdResponseBO> products = itemService.getProductsBySkuId(getProductBySkuIdBO.getSkuids(), getProductBySkuIdBO.getPartnerId(),
                getProductBySkuIdBO.getStoreId(), getProductBySkuIdBO.getMenuType());


        return products;
    }

    @Override
    public List<ProductStockBO> getProductStock(GetProductStock getProductStock) {

        GetProductStockRequestDto getProductStockRequestDto = productBO2DTOAdapter.convert2GetProductStockDto(getProductStock);

        GetProductStockResponseDto availableStocks = stockClient.getAvailableStocks(getProductStockRequestDto);
        List<GetProductStockResponseDto.DataBean> result = availableStocks.getResult();

        if (availableStocks != null && !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(availableStocks.getCode())) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_STOCK_NOT_HAVE);
        }

        List<ProductStockBO> list = new ArrayList<>();
        for (GetProductStockResponseDto.DataBean dataBean : result){
            ProductStockBO productStockBO = productDTO2BOAdapter.convert2ProductStockBO(dataBean);
            list.add(productStockBO);
        }
        return list;

    }

    @Override
    public ValiadShopProductBO validateShopProduct(ValidateShopProductRequestBO validateShopProductRequestBO) {

        ValidateShopProductRequest validateShopProductRequest = productBO2DTOAdapter.convert2ValidateShopProductRequest(validateShopProductRequestBO);

        ProductResponseDTO<ValiadShopProductResponse> valiadProductResponse = storeItemClient.validateShopProduct(validateShopProductRequest);
        if (null == valiadProductResponse || !Objects.equals(com.freemud.application.sdk.api.productcenter.constant.ResponseConstant.SUCCESS_RESPONSE_CODE, valiadProductResponse.getErrcode())
                || valiadProductResponse.getData() == null) {
            return null;
        }
        ValiadShopProductBO valiadShopProductBO = productDTO2BOAdapter.convert2ProductStockBO(valiadProductResponse.getData());

        return valiadShopProductBO;
    }
}
