package cn.freemud.demo.entities;

import lombok.Data;

import java.util.List;

@Data
public class GoodsBeanBO {

    /**
     * 商品编号（与商品类目必传其一） /activity/query入参
     */
    private String goodsId;
    /**
     * 商品类目（与商品ID必传其一）
     */
    private String category;
    /**
     * 商品名称
     */
    private String goodsName;
    /**
     * 商品原价（分） /activity/query入参
     */
    private Integer originalPrice;
    /**
     * 现价（分）
     */
    private Integer nowPrice;
    /**
     * 活动总库存
     */
    private Integer quantityLimit;
    /**
     * 折扣率（单品，如果活动类型为折扣，则与整单折扣率必传其一）
     */
    private Integer rebate;
    /**
     * 买M（单品折扣时必传，表示第n个该商品打多少折；买M送N时必传，表示买该商品n个）
     */
    private Integer number;
    /**
     * 0：不可用  1：可用（不传默认为1）
     */
    private Integer isCanUse;
    /**
     * 是否与其他活动共享，0:不共享 1：共享（不传默认为0）
     */
    private Integer isShare;
    /**
     * 商品类目
     */
    private Integer type;
    /**
     * 共享/不共享的活动号
     */
    private List<String> shareActivityCodes;
    /**
     * 共享/不共享的活动类型
     */
    private List<Integer> shareActivityTypes;

}
