package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.update.UpdateAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.BaseAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.MCoffeeAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.PlatformAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.update.BaseUpdateGoodsQtyVO;
import cn.freemud.demo.entities.dto.goods.add.update.MCoffeeUpdateGoodsQtyVO;
import cn.freemud.demo.entities.dto.goods.add.update.PlatformUpdateGoodsQtyVO;
import cn.freemud.demo.enums.BizTypeEnum;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class UpdateGoodsQtyVOAdapter {
    @Resource
    private MapperFacade mapperFacade;

    public BaseUpdateGoodsQtyVO convert2AddGoodsVO(String bizType, ShoppingCartGoodsBO baseAddGoodsBO) {
        BaseUpdateGoodsQtyVO baseAddGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }


    private PlatformUpdateGoodsQtyVO createPlatformVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        PlatformUpdateGoodsQtyVO platformAddGoodsVO = mapperFacade.map(baseAddGoodsBO, PlatformUpdateGoodsQtyVO.class);
        return platformAddGoodsVO;
    }

    private MCoffeeUpdateGoodsQtyVO createMCoffeeVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        MCoffeeUpdateGoodsQtyVO mCoffeeAddGoodsVO = new MCoffeeUpdateGoodsQtyVO();
        return mCoffeeAddGoodsVO;
    }

}
