package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.ActivityBO;
import cn.freemud.demo.entities.CalculationDiscountBO;
import cn.freemud.demo.entities.GetCalculationDiscountBO;
import cn.freemud.entities.dto.ActivityResponseDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class PromotionDTO2BOAdapter {


    @Resource
    private MapperFacade mapperFacade;

    public CalculationDiscountBO convert2CalculationDiscountBO(CalculationSharingDiscountResponseDto dto) {
        CalculationDiscountBO bo = mapperFacade.map(dto, CalculationDiscountBO.class);
        return bo;
    }

    public ActivityBO convert2ActivityBO(ActivityResponseDto dto) {
        ActivityBO bo = mapperFacade.map(dto, ActivityBO.class);
        return bo;
    }


}
