package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.ProductStockBO;
import cn.freemud.demo.entities.ValiadShopProductBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.application.sdk.api.productcenter.response.valid.ValiadShopProductResponse;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ProductDTO2BOAdapter {


    @Resource
    private MapperFacade mapperFacade;

    public ProductBO convert2ProductBO(ProductBeanDTO productBeanDTO) {

        ProductBO productBO = mapperFacade.map(productBeanDTO, ProductBO.class);

        return productBO;
    }

    public ProductStockBO convert2ProductStockBO(GetProductStockResponseDto.DataBean ProductStockDTO) {

        ProductStockBO productStockBO = mapperFacade.map(ProductStockDTO, ProductStockBO.class);
        return productStockBO;
    }


    public ValiadShopProductBO convert2ProductStockBO(ValiadShopProductResponse valiadShopProductResponse) {

        ValiadShopProductBO bo = mapperFacade.map(valiadShopProductResponse, ValiadShopProductBO.class);
        return bo;
    }

}
