package cn.freemud.handle;

import cn.freemud.entities.dto.console.*;
import cn.freemud.entities.dto.order.PackAmountConfig;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.CreateOrderType;
import cn.freemud.enums.OrderType;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.thirdparty.ConsoleApiClient;
import cn.freemud.utils.RedisUtil;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.log.ApiLog;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/7/23 上午11:58
 * @description :
 */
@Component
public class CommonFunctionHandle {


    @Autowired
    private ConsoleApiClient consoleApiClient;
    @Autowired
    private RedisCache redisCache;


    /**
     * 查询配置，比较配送费
     */
    public PackAmountConfig getPackAmountByOrderConfig(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo, PackAmountConfig newPackAmountConfig,Long totalAmount) {
        if (Objects.equals(shoppingCartInfoRequestVo.getOrderType(), CreateOrderType.TAKE_OUT.getCode())
                || Objects.equals(shoppingCartInfoRequestVo.getReachStoreType(), OrderType.COLLECT_GOODS.getCode())) {
            String redisKey = RedisUtil.packAmountConfig + shoppingCartInfoRequestVo.getPartnerId() + "_" + null;
            String value = redisCache.hashGet(redisKey, "packAmountType");
            if(StringUtils.isEmpty(value)){
                return newPackAmountConfig;
            }
            Long newPackAmount = newPackAmountConfig.getNewPackAmount();
            ApiLog.printLog("查询订单餐盒费配置", String.valueOf(newPackAmount), String.valueOf(totalAmount), value);
            PackAmountConfig packAmountConfig = JSONObject.parseObject(value, PackAmountConfig.class);
            //按商品级别收取餐盒费
            if(packAmountConfig == null || CollectionUtils.isEmpty(packAmountConfig.getCollectType())){
                return newPackAmountConfig;
            }
            //按订单级别收取餐盒费
            List<PackAmountConfig.CollectType> collectTypes = packAmountConfig.getCollectType();
            collectTypes.sort((p1, p2) -> p2.getOrderAmount() - p1.getOrderAmount());
            newPackAmount = 0L;
            for (PackAmountConfig.CollectType collectType: collectTypes){
                if(totalAmount >= collectType.getOrderAmount()){
                    newPackAmount = collectType.getFee().longValue();
                    break;
                }
            }
            newPackAmountConfig.setNewPackAmount(newPackAmount);
            newPackAmountConfig.setCollectType(collectTypes);
        }
        return newPackAmountConfig;
    }

    /**
     * fisherman 【ID1033456】自提根据模板配置计算餐具包装费
     *
     * @param shoppingCartInfoRequestVo
     * @param newPackAmount
     * @return 外卖 true 打包带走 false  null 为其他业务问题 不进入需求
     */
    public PackAmountConfig getPackAmountByStoreConfig(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo, Long newPackAmount,Long totalAmount) {
        PackAmountConfig newPackAmountConfig = new PackAmountConfig();
        newPackAmountConfig.setNewPackAmount(newPackAmount);
        if (Objects.isNull(shoppingCartInfoRequestVo)) {
            return newPackAmountConfig;
        }
        //查询餐盒费配置，按订单金额或商品配置
        newPackAmountConfig = getPackAmountByOrderConfig(shoppingCartInfoRequestVo, newPackAmountConfig, totalAmount);
        newPackAmount = newPackAmountConfig.getNewPackAmount();
        Boolean isTakeOut = null;
        if (Objects.equals(shoppingCartInfoRequestVo.getOrderType(), CreateOrderType.TAKE_OUT.getCode())) {
            isTakeOut = true;
        } else if (Objects.equals(shoppingCartInfoRequestVo.getReachStoreType(), OrderType.COLLECT_GOODS.getCode())) {
            isTakeOut = false;
        }
        ApiLog.printLog("自提根据模板配置计算餐具包装费", String.valueOf(newPackAmount), String.valueOf(isTakeOut), null);
        if (Objects.isNull(newPackAmount) || newPackAmount.compareTo(0L) == 0) {
            newPackAmountConfig.setNewPackAmount(0L);
            return newPackAmountConfig;
        }
        //isTakeOut 非外卖或到店自提，直接返回
        if (Objects.isNull(isTakeOut)) {
            return newPackAmountConfig;
        }
        GetStoreMixRequest request = GetStoreMixRequest.builder().partnerId(shoppingCartInfoRequestVo.getPartnerId()).storeCode(shoppingCartInfoRequestVo.getShopId()).build();
        // 查询 业务设置信息数据
        request.setQuery(QueryFlag.builder().queryBusinessInfo(Boolean.TRUE).build());
        ConsoleResponseDTO<BizDTO> responseDTO = consoleApiClient.getStoreMix(request);
        BizDTO bizVO = responseDTO.getBizVO();
        if (Objects.nonNull(bizVO) && Objects.nonNull(bizVO.getBusinessInfo())) {
            // 查出 有配置 并且有开关 就判断 否则就走 默认值
            ExpandFieldsDTO expandFields = bizVO.getBusinessInfo().getExpandFields();
            if (Objects.nonNull(expandFields)) {
                if (isTakeOut) {
                    // 外卖 是否计算 包装费
                    if (Objects.nonNull(expandFields.getDeliveryPackageFeeSwitch())
                            && ExpandFieldsDTO.STR_FALSE.equals(expandFields.getDeliveryPackageFeeSwitch())) {
                        newPackAmountConfig.setNewPackAmount(0L);
                        return newPackAmountConfig;
                    }
                } else {
                    // 打包带走 是否计算包装费
                    if (Objects.nonNull(expandFields.getPickupPackageFeeSwitch())
                            && ExpandFieldsDTO.STR_FALSE.equals(expandFields.getPickupPackageFeeSwitch())) {
                        newPackAmountConfig.setNewPackAmount(0L);
                        return newPackAmountConfig;
                    }
                }
            }
        }
        return newPackAmountConfig;
    }

}
