package cn.freemud.adapter;

import cn.freemud.entities.dto.BuriedPointPaymentRequestDto;
import cn.freemud.entities.vo.SpuProductVo;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class BuriedAdapter {
    public BuriedPointPaymentRequestDto convert2BuriedPointPaymentRequestDto(List<SpuProductVo> productVoList){
        BuriedPointPaymentRequestDto requestDto=new BuriedPointPaymentRequestDto();
        List<BuriedPointPaymentRequestDto.ProductBean> productBeans= Lists.newArrayList();
        int i=1;
        for (SpuProductVo productVo:productVoList){
            BuriedPointPaymentRequestDto.ProductBean productBean=new BuriedPointPaymentRequestDto.ProductBean();
            productBean.setPosition(i);
            productBean.setSpuId(productVo.getSpuId());
            productBean.setSpuName(productVo.getSpuName());
            productBeans.add(productBean);
            i++;
        }
        requestDto.setProductBean(productBeans);
        return requestDto;
    }
}
