package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

@Data
public class GetMemberInfoRequestDto {

    private String partnerId;

    private String mobile;

    private String userId;

    /**
     * 储值卡状态 0可用1转赠中2已转赠3已移除
     */
    private List<Integer> statusFlagList;


    /**
     * 实际支付金额（分）
     */
    private Integer actualPayAmount;

    /**
     * 下单门店号
     */
    private String storeId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 订单原金额（分）
     */
    private Integer originalAmount;

    /**
     * 下单渠道
     */
    private Integer orderClient;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 支付渠道
     */
    private String payChannel;

    /**
     * 支付渠道名称
     */
    private String payChannelName;

    /**
     * pos编号
     */
    private String posCode;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 是否赠送积分 0是1否
     */
    private Integer needBonus;

    /**
     * 订单商品信息
     */
    private List<OrderItemRequest> orderItemList;

    @Data
    public static class OrderItemRequest {

        /**
         * 商品序号
         */
        private Integer productSeq;

        /**
         * 平台商品编号
         */
        private String productId;

        /**
         * 商家商品编号
         */
        private String thirdProductId;

        /**
         * 商品名称
         */
        private String productName;

        /**
         * 商品单价（分）
         */
        private Integer productPrice;

        /**
         * 数量
         */
        private Integer productQuantity;

        /**
         * 优惠分摊金额（分）
         */
        private Integer productSharePrice;

        /**
         * 商品单位
         */
        private String productWeightUnit;

        /**
         * 商品重量（克）
         */
        private Integer weight;

        /**
         * 商品规格名称（大杯）
         */
        private String productSpecName;

        /**
         * 商品属性名称（三分糖）
         */
        private String productProperty;

        /**
         * 商家商品分类编号
         */
        private String thirdCateCode;

        /**
         * 是否算积分
         */
        private String needBonus;


    }


}
