package cn.freemud.service.adapter;

import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.CreateOrderType;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;

import java.util.Objects;

/**
 * 外卖订单检查
 */
public class TakeOutOrderCheck extends AbstractOrderCheck {

    @Override
    public boolean support(int orderType) {
        return CreateOrderType.TAKE_OUT.getCode() == orderType;
    }
    @Override
    public void check(CreateOrderVo vo, StoreResponse storeResponse) {
        StoreResponse.BizVO bizVO = storeResponse.getBizVO();
        StoreResponse.Configuration storeConfig = bizVO.getStoreConfig();
        // 关闭预约单
        if (Objects.equals(storeConfig.getDeliveryAppoint(), 0)) {
            super.doStoreStateCheck(bizVO);
        }


    }

}
