package cn.freemud.service.impl;

import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.service.adapter.OrderManagerAdapter;
import cn.freemud.management.thirdparty.MulitiPaymentClient;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.request.OrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.service.OrderDownLoadSdkService;
import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.utils.ValidationCode;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;
import springfox.documentation.spring.web.json.Json;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MallOrderServiceImplTest {

    @Autowired
    private OrderDownLoadSdkService orderDownLoadSdkService;

//    @Autowired
//    private MallOrderServiceImpl mallOrderService;
//
    @Autowired
    private MCCafeOrderServiceImpl mcCafeOrderService;
//
//    @Autowired
//    private MulitiPaymentClient mulitiPaymentClient;
//
//    @Autowired
//    private OrderManagerAdapter orderManagerAdapter;
    @Autowired
    private MulitiPaymentClient mulitiPaymentClient;
    @Autowired
    private OrderServiceImpl orderService;


    @Autowired
    private OrderManagerAdapter orderManagerAdapter;

//    @Before
//    public void before() throws Exception {
//    }
//
//    @After
//    public void after() throws Exception {
//    }

    @After
    public void after() throws Exception {
    }

    @Test
    public void f1() {
        mcCafeOrderService.createOrder(JSON.parseObject("{\"channelType\":\"saas\",\"partnerId\":\"1206\",\"appId\":\"wx6816a0b007741702\",\"sessionId\":\"ef7f2839e35e7a4f7d21dd1fc26157a4862698a5\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"1450026\",\"couponCode\":\"\",\"payChannelType\":1,\"reachStoreType\":5,\"takeMealFlag\":\"0\",\"needInvoice\":0,\"orderRemark\":\"\",\"receiveId\":\"\"}", CreateOrderVo.class),
                new StoreResponse.BizVO(),
                JSON.parseObject("{\"activityDiscountsDtos\":[{\"activityCode\":\"CZJG2020091815220412683\",\"activityName\":\"terry0918eee\",\"activityType\":23,\"discountAmount\":-2200}],\"deliveryAmount\":0,\"discountDeliveryAmount\":0,\"isDiscountDelivery\":false,\"originalTotalAmount\":7100,\"packageAmount\":0,\"products\":[{\"activityDiscountsDtos\":[{\"activityCode\":\"CZJG2020091815220412683\",\"activityName\":\"terry0918eee\",\"activityType\":23,\"actualActivityGoodsNumber\":1,\"discountAmount\":2200}],\"activityType\":2,\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"categoryName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"customerCode\":\"508120\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[],\"originalPrice\":2300,\"picture\":\"https://picture.sandload.cn/1598681143874.png\",\"productCode\":\"901126\",\"qty\":1,\"skuId\":\"184440231236332839\",\"skuName\":\"红茶拿铁-中杯\",\"spuId\":\"184440231236332839\",\"spuName\":\"红茶拿铁-中杯\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":2200},{\"activityDiscountsDtos\":[],\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"2217\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":1900,\"parentProductId\":\"184437712179293469\",\"picture\":\"https://picture.sandload.cn/1598675643524.png\",\"productType\":6,\"qty\":2,\"skuId\":\"181574788508098858\",\"skuName\":\"中杯拿铁\",\"spuId\":\"181574788508098858\",\"spuName\":\"中杯拿铁\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"508134\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":2100,\"parentProductId\":\"184437712179293469\",\"picture\":\"https://picture.sandload.cn/1598675940164.png\",\"productType\":6,\"qty\":2,\"skuId\":\"184434761663638803\",\"skuName\":\"经典芝士蛋糕\",\"spuId\":\"184434761663638803\",\"spuName\":\"经典芝士蛋糕\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":3200,\"unit\":\"\",\"weight\":0.0}],\"customerCode\":\"508131\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[],\"originalPrice\":4800,\"picture\":\"https://picture.sandload.cn/1598678713405.png\",\"productCode\":\"508131\",\"productType\":6,\"qty\":2,\"skuId\":\"184437712179293469\",\"skuName\":\"早餐啡常搭\",\"spuId\":\"184437712179293469\",\"spuName\":\"早餐啡常搭\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"totalAmount\":4900,\"totalDiscountAmount\":2200}", ShoppingCartGoodsDto.class),
                new OrderExtendedReq(),
                OrderClientType.SAAS,"www");
    }
//    @Test
//    public void testAffirm() {
//        OrderAffirmRequestVO requestVO = new OrderAffirmRequestVO();
//        requestVO.setPartnerId("1864");
//        requestVO.setShopId("8899");
//        requestVO.setSessionId("123123");
//        requestVO.setChannelType("saasmall");
//        requestVO.setOid("16303606485084241800003");
//        mallOrderService.orderAffirm(requestVO);
//    }

    @Test
    public void f2() {
        mcCafeOrderService.mcCafePaySuccessCallback(JSON.parseObject("{\"endTransId\":\"4200000731202010272812645480\",\"merchantCoupon\":0,\"openId\":\"oDF-Z5aYxM8xBKAzCeYCcdAIByT4\",\"partnerId\":\"1205\",\"platformCoupon\":0,\"platformMchId\":\"1259889901\",\"resultCode\":\"100\",\"thirdPartTradeNo\":\"4200000731202010272812645480\",\"totalAmount\":3800,\"tradeTime\":\"20201027170829\",\"transCurrency\":\"CNY\",\"transId\":\"19267384897250820300001\",\"transactionCode\":\"TSXA1205O230012700873498624\"}"
                , NewPaysuccessNoticeMessage.class));
    }

    @Test
    public void f3() {
        orderService.mcCafeQueryOrderById(JSON.parseObject("{\"channelType\":\"saas\",\"partnerId\":\"1206\",\"appId\":\"wx6816a0b007741702\",\"sessionId\":\"07e359b4147ef0182951b2c064f5ec8d716a702a\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"1450026\",\"oid\":\"19284932547021936900006\"}", MaCafeQueryOrderVo.class));
    }

    @Test
    public void test() {
//        MultiOrderRefundRequest multiOrderRefundRequest = new MultiOrderRefundRequest();
//        multiOrderRefundRequest.setFmId("");
//        multiOrderRefundRequest.setVer3(false);
//        multiOrderRefundRequest.setVer("V1");
//        multiOrderRefundRequest.setNotifyUrl("http://open-store-order-application-service.open-store.svc:9212/order/refundNotifyCallback");
//        multiOrderRefundRequest.setOperatorId("1");
//        multiOrderRefundRequest.setPartnerId("1864");
//        multiOrderRefundRequest.setRefundAmount(1L);
//        multiOrderRefundRequest.setRefundTradeNo("1604886134387{{$timestamp}}");
//        multiOrderRefundRequest.setStationId("1");
//        multiOrderRefundRequest.setStoreId("999999998");
//        multiOrderRefundRequest.setOutOrderNo("3900472893821604933666");
//        MultiOrderRefundResponse<MultiOrderRefundResponse.Data> multiOrderRefundResponseDto = mulitiPaymentClient.paymentApplicationRefund(multiOrderRefundRequest,"1864");
//        System.out.println(2345678);
//        OrderManagerRequest orderManagerRequest = new OrderManagerRequest();
//        orderManagerRequest.setOrderId("19404015572678969200003");
//        orderManagerRequest.setPartnerId("1864");
//        orderManagerAdapter.orderAgreeRefund(orderManagerRequest);
        OrderConditionsReq request ;
        String str = "{\"abnormalStatuses\":[],\"afterSalesStatus\":0,\"appId\":\"\",\"bizType\":0,\"bizTypes\":[1,6,97,98],\"dispenseStatus\":0,\"endTimestamp\":1605542399,\"endUpdateTimestamp\":0,\"expressType\":0,\"externalObjectIds\":[],\"finishStatus\":false,\"isDeleted\":0,\"mobile\":\"\",\"orderClients\":[],\"orderCode\":\"19356550932276285500005\",\"orderCodes\":[],\"orderStatus\":0,\"orderStatuses\":[],\"orderTypes\":[],\"pageNum\":1,\"pageSize\":10,\"partnerId\":\"2655\",\"payStatuses\":[2,3,4],\"payTypes\":[],\"printNum\":0,\"productId\":\"\",\"productName\":\"\",\"settlementTypes\":[],\"startTimestamp\":1604160000,\"startUpdateTimestamp\":0,\"storeIds\":[],\"suspendState\":0,\"thirdOrderCode\":\"\",\"userId\":\"\",\"userName\":\"\"}";
        request = JSON.toJavaObject(JSON.parseObject(str),OrderConditionsReq.class);
        orderDownLoadSdkService.queryOrderByConditions(request,"");
    }


}
