package com.freemud.sdk.api.assortment.order.response.order;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.util.List;

/**
 * 聚合退款返回
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MultiOrderRefundResponse<T> {
    private int code;

    private String msg;

    private T data;

    @lombok.Data
    public class Data {
        public List<RefundPlatformResponse> refundPlatformResponseList;
    }

    @lombok.Data
    public static class RefundPlatformResponse{
        private String endTransTradeNo;
        private String fmRefundNo;
        private String fmTradeNo;
        private Integer mcouponAmount;
        private Integer pcouponAmount;
        private String platformTradeNo;
        private Integer refundAmount;
        private String refundCurrency;
        private String refundDesc;
        private String refundEndTransTradeNo;
        private String refundTime;
        private String refundTradeNo;
        private Integer settleRefundAmount;
        private Integer totalAmount;
        private String transId;
        private String ebCode;
    }
}