/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderPayResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/25 17:10
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto.pay;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import java.util.List;

@NoArgsConstructor
@Data
@ToString
public class CombPayResponse {
    private int code;

    @ApiModelProperty(value = "提示信息")
    private String msg;
    private PayPlatforms data;

    @Data
    public static class PayPlatforms {
        private List<PayPlatform> payPlatformResponseList;
    }
    @Data
    static public class PayPlatform {

        @ApiModelProperty(value = "app_id编号(微信使用)")
        private String appId;

        @ApiModelProperty(value = "支付渠道编号")
        private String ebCode;

        //@ApiModelProperty(value = "验签可配置")
        private String sign;

        @ApiModelProperty(value = "非码交易流水号")
        private String fmTradeNo;

        @ApiModelProperty(value = "随机字符串(微信使用)")
        private String nonceStr;

        @ApiModelProperty(value = "外部交易流水号，由上游系统生成，需保证唯一")
        private String outOrderNo;

        @ApiModelProperty(value = "包名(微信使用)")
        @JsonProperty("package")
        private String _package;

        @ApiModelProperty(value = "支付帐号")
        private String payAccount;

        @ApiModelProperty(value = "签名(微信使用)")
        private String paySign;

        @ApiModelProperty(value = "签名类型(微信使用)")
        private String paySignType;

        @ApiModelProperty(value = "支付渠道描述")
        private String platformDesc;

        @ApiModelProperty(value = "第三方支付交易序号")
        private String platformTradeNo;

        @ApiModelProperty(value = "预订单编号")
        private String prepayId;

        @ApiModelProperty(value = "时间戳(微信使用)")
        private String timestamp;

        @ApiModelProperty(value = "间联单号")
        private String transId;
        @ApiModelProperty(value = "")
        private PayOrderBean payOrder;
        @Data
        public static class PayOrderBean {
            /**
             * appid : wx3ab08e23966343fe
             * package : prepay_id=wx25143630149413bcd9fbad100070370076
             * nonce_str : -610630281
             * sign : D320B2B74D858EBE16841F43AE70E757
             * timestamp : 1527230190
             * signType : MD5
             */
            private String appid;

            @JsonProperty("package")
            private String packageX;

            //@JsonProperty("nonce_str")
            private String nonceStr;

            private String sign;

            private String timestamp;

            private String signType;
            private String aliPayOrder;
        }
    }
}
