package cn.freemud.aop;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @author
 */

@Retention(RetentionPolicy.RUNTIME)
public @interface LogIgnore {
    /**
     * 是否打印日志，true打印，false不打印，注意设置成false状态码和状态码信息都不会打印
     *
     * @return
     */
    boolean printLog() default true;

    /**
     * printLog 设置成true的时候，可以排除哪些状态码的响应不用打印响应报文，只会打印状态码
     * 默认成功100
     * @return
     */
    String[] excludeStatusCodes() default "100";

    /**
     * statusCodeFieldName 默认返回状态码字段为code
     *
     * @return
     */
    String statusCodeFieldName() default "code";

    /**
     * statusCodeFieldName 默认返回状态码字段为message
     *
     * @return
     */
    String messageFieldName() default "message";

    /**
     * logMessage 日志打印
     * @return
     */
    String logMessage() default "";
}
