package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;

import java.util.List;

@Data
public class QueryOrdersRequest extends BaseConfig {

    /**
     * 用户会员ID
     */
    private String userId;
    /**
     * 用户id集合（userId和userIds两者不能同时为空）
     */
    private List<String> userIds;
    /**
     * 商户ID
     */
    private String companyId;
    /**
     * 每页显示几条数据
     */
    private Integer pageSize;
    /**
     * 第几页
     */
    private Integer pageNumber;
    /**
     * 订单创建开始日期
     */
    private String startDate;
    /**
     * 订单结束日期
     */
    private String endDate;
    /**
     * 支付状态
     */
    private Integer[] payStatus;
    /**
     * 订单状态
     */
    private Integer[] status;
    /**
     * 退款状态
     */
    private Integer[] refundStatus;
    /**
     * 订单类型    enumsRefundStatus
     */
    private Integer[] type;
    /**
     * 查询是否生成取餐码订单1:是，0 否 ,
     */
    private Integer existTakeCode;
    /**
     * 资源渠道
     */
    @Deprecated
    private String[] source;

    //替代老的source字段
    private List<Integer> orderClients;

    private List<Integer> bizTypes;

    /**
     * 是否已开发票，false查询可开票订单，true查询其他订单（包含已开票/已退款订单）
     */
    private Boolean needInvoice;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    private Integer marketingType;

    /**
     * 1:可开票，2:已开票,3:其他(不可开票)
     */
    private Integer invoiceState;

    /**
     * 查询订单状态 1 外卖  4 门店自提
     */
    private Integer queryOrderType;

    private List<Integer> marketingTypes;


}
