package cn.freemud.service.thirdparty;


import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.interceptor.FormSupportConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(name = "OPEN-STORE-ONLINE-COUPON-SERVICE", url = "${saas.coupononlineclient.feign.url}", configuration = FormSupportConfig.class)
public interface CouponOnlineClient {
    /**
     * 查询券详情
     */
    @IgnoreFeignLogAnnotation(logMessage = "getCouponDetails",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/code_v4", produces = MediaType.APPLICATION_JSON_UTF8_VALUE,
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE}
    )
    GetCouponDetailResponseDto getCouponDetails(@RequestParam Map<String, ?> map);

}
