package cn.freemud.service.impl.calculate;

import cn.freemud.constant.ShoppingCartConstant;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.calculate.CalculationDiscountResult;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.CouponPromotionVO;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.service.impl.calculate.promotion.*;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate CalculationSharingCartService
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/9/7
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class CalculationSharingCartService {

    @Autowired
    private CouponSharingService promotionSharingService;

    @Autowired
    private FullSharingService fullSharingService;

    @Autowired
    private ScoreSharingService scoreSharingService;

    @Autowired
    private DeliverySharingService deliverySharingService;

    @Autowired
    private GiftSharingService giftSharingService;

    @Autowired
    private AdditionSharingService additionSharingService;
    @Autowired
    private CalculationCommonService calculationCommonService;

    @Autowired
    private BuyOneGiveOneSendService buyOneGiveOneSendService;

    /**
     * 响应购物车价格计算依赖促销
     */
    public void distribute(CalculationDiscountResult discountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , ShoppingCartInfoRequestVo shoppingCartInfoRequestVo
            , UserLoginInfoDto userLoginInfoDto
            , CouponPromotionVO couponPromotionVO
            , ActivityQueryDto activityQueryDto
            , String menuType
            , Long deliveryAmount
            , String opt
            , String partnerId
            , Integer flag
            , String userId
            , String storeId) {

        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult,
                cartGoodsList,
                shoppingCartGoodsResponseVo,
                couponPromotionVO != null ? couponPromotionVO.getCouponCode() : null,
                shoppingCartInfoRequestVo);

        if (BusinessTypeEnum.SAAS_MALL.getCode().equals(menuType) && null != shoppingCartInfoRequestVo && OrderChannelType.SAASMALL.getCode().equalsIgnoreCase(shoppingCartInfoRequestVo.getChannelType())) {
            deliverySharingService.mallDeliveryResponse(shoppingCartGoodsResponseVo, deliveryAmount,discountResult);
        }
        /**
         * 可用券及券折扣
         */
        promotionSharingService.updateShoppingCartGoodsDiscount(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, couponPromotionVO,shoppingCartInfoRequestVo, userId, partnerId, storeId, activityQueryDto.getOrderType(),activityQueryDto.getBizType());

        /**
         * 满减处理
         */
        fullSharingService.fullResponse(discountResult,cartGoodsList,shoppingCartGoodsResponseVo,activityQueryDto);

        /**
         * 买赠
         */
        giftSharingService.giftResponse(discountResult, cartGoodsList, shoppingCartInfoRequestVo, activityQueryDto, partnerId, storeId, userId, flag);

        /**
         * 加价购
         */
        additionSharingService.additionResponse(discountResult,cartGoodsList,shoppingCartGoodsResponseVo,shoppingCartInfoRequestVo);
        /**
         * 积分抵扣
         */
        scoreSharingService.scoreResponse(discountResult, shoppingCartGoodsResponseVo, userLoginInfoDto, shoppingCartInfoRequestVo);
        if(BusinessTypeEnum.SAAS_DELIVERY.getCode().equals(menuType)){
            deliverySharingService.deliveryResponse(discountResult, activityQueryDto, shoppingCartGoodsResponseVo, deliveryAmount);
        }


        /**
         * 特价类型超出部分提示
         */
        calculationCommonService.drawSurpassDiscountInfo(discountResult, shoppingCartGoodsResponseVo);
        if (ShoppingCartConstant.ADD_AND_UPDATE.equals(opt)) {
            calculationCommonService.setAddAndUpdateResponse(cartGoodsList, shoppingCartGoodsResponseVo, shoppingCartInfoRequestVo, ShoppingCartConstant.ADD_AND_UPDATE);
        } else if (ShoppingCartConstant.QUERY_INFO.equals(opt)) {
            calculationCommonService.setAddAndUpdateResponse(cartGoodsList, shoppingCartGoodsResponseVo, shoppingCartInfoRequestVo, ShoppingCartConstant.QUERY_INFO);
            calculationCommonService.addNeedCardAmount(shoppingCartInfoRequestVo, shoppingCartGoodsResponseVo);
        }

        /**
         * 买一赠一寄杯
         */
        buyOneGiveOneSendService.giftResponse(discountResult, cartGoodsList, shoppingCartInfoRequestVo, activityQueryDto,shoppingCartGoodsResponseVo);

    }
}
