package cn.freemud.entities.dto.calculate;

import lombok.Data;

import java.util.List;

@Data
public class Goods {

    /**
     * 买一赠一时，存赠送主商品的cartGoodsUid 用于标记是那个商品送的
     */
    private String originalGoodsUid;

    /**
     * 购物车行记录
     */
    private String cartGoodsUid;
    /**
     * 0 原购物车商品 1 赠送商品  2 换购商品
     */
    private Integer cartGoodType;
    /**
     * 商品id
     */
    private String goodsId;
    /**
     * 商品数量
     */
    private Integer goodsQuantity;
    /**
     * 商品原价（分）
     */
    private Long originalPrice;
    /**
     * 商品现价（分）
     */
    private Long nowPrice;
    /**
     * 分摊到商品上的优惠总金额
     */
    private Long discountAmount;
    /**
     * 商品实付金额
     */
    private Long realAmount;
    /**
     * 实际优惠的商品数量
     */
    private Integer actualGoodsNumber;

    //商品积分数量
    private Long score;
    /**
     * 单品享受的活动
     */
    private List<GoodsDiscount> discounts;

    /**
     * 活动键位编号
     */
    private String artNo;

    /**
     * 套餐固定商品组
     */
    private List<GroupCombox> groupCombox;
    /**
     * 商品的小料集合
     */
    private List<SmallMaterial> smallMaterial;
    private Boolean gift = false;
    private Boolean meal = false;

}
