package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

public enum OrderStatusV1 {

    PENDING_PAYMENT("待支付",2,1,"To be paid"),
    PLACE_AN_ORDER( "下单",1,2,"place an order"),
    ACCEPTED("已接单",3,3,"Receiving orders"),
    PRODUCED("制作完成(待发货)",31,4,"Production completed"),
    DELIVERING("配送中",4,5,"In delivery"),
    COMPLETE( "已完成",5,6,"Complete"),
    CLOSED( "已关闭",6,7,"Cancel")

    ;

    private String name;
    private Integer v1Code;
    private Integer v2Code;
    private String descEn;


    /**
     * 获取V1 老订单状态值
     */
    public static Integer getOldCode(Integer v2Code) {
        Integer v1Code = OrderStatusV1.PENDING_PAYMENT.getV1Code();
        if (v2Code == null ) return v1Code;
        for (OrderStatusV1 value : OrderStatusV1.values()) {
            if (value.getV2Code().equals(v2Code)) {
                v1Code = value.getV1Code();
                break;
            }
        }
        return v1Code;
    }

    /**
     * 获取V2 新订单状态值
     */
    public static Integer getNewCode(Integer v1Code) {
        Integer v2Code = OrderStatusV1.PENDING_PAYMENT.getV2Code();
        if (v1Code == null ) return v2Code;
        for (OrderStatusV1 value : OrderStatusV1.values()) {
            if (value.getV1Code().equals(v1Code)) {
                v2Code = value.getV2Code();
                break;
            }
        }
        return v2Code;
    }


    public static Integer[] getAllCodes() {
        Integer[] codeArray = new Integer[values().length];
        int i = 0;
        for (OrderStatusV1 orderStatusV1 : values()) {
            codeArray[i] = orderStatusV1.getV1Code();
            i++;
        }
        return codeArray;
    }

    OrderStatusV1(String name, Integer v1Code, Integer v2Code, String descEn) {
        this.name = name;
        this.v1Code = v1Code;
        this.v2Code = v2Code;
        this.descEn = descEn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getV1Code() {
        return v1Code;
    }

    public void setV1Code(Integer v1Code) {
        this.v1Code = v1Code;
    }

    public Integer getV2Code() {
        return v2Code;
    }

    public void setV2Code(Integer v2Code) {
        this.v2Code = v2Code;
    }
}
