package cn.freemud.management.service.handle;

import cn.freemud.management.entities.dto.request.activity.GroupWorkRefundRequest;
import cn.freemud.management.entities.dto.response.activity.GroupWorkRefundResponse;
import cn.freemud.management.thirdparty.OMSActivityClient;
import com.freemud.sdk.api.assortment.order.domain.ResponseCodeConstant;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ActivityHandle {

    private final OMSActivityClient omsActivityClient;

    public ActivityHandle(OMSActivityClient omsActivityClient) {
        this.omsActivityClient = omsActivityClient;
    }

    public GroupWorkRefundResponse groupWorkRefund(QueryOrdersResponse.DataBean.OrderBean orderBean){
        GroupWorkRefundRequest groupWorkRefundRequest = new GroupWorkRefundRequest(orderBean.getSpellGroupActivityCode(),orderBean.getCompanyId(),orderBean.getSpellGroupCode(),orderBean.getOid(),orderBean.getUserId());
        GroupWorkRefundResponse groupWorkRefundResponse = omsActivityClient.groupWorkRefund(groupWorkRefundRequest);
        if (!ResponseCodeConstant.RESPONSE_SUCCESS.equals(groupWorkRefundResponse.getStatusCode())) {
            return null;
        }
        return groupWorkRefundResponse;
    }
}
