package com.freemud.sdk.api.assortment.shoppingcart.constant;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.sdk.api.assortment.shoppingcart.constant
 * @Descripttion:
 * @author: cuigenyou
 * @date: 2019/9/4 17:49
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
public enum MealClearOperationEnum {

    CLEAR_LOCK(1,"clearLock"),
    RECOVER(2,"recoverLock"),
    CLEAR_ALL(3,"clearAll"),
    ;

    private Integer operationType;

    private String method;


    MealClearOperationEnum(Integer operationType, String method) {
        this.operationType = operationType;
        this.method = method;
    }

    public Integer getOperationType() {
        return operationType;
    }

    public String getMethod() {
        return method;
    }

    public static MealClearOperationEnum getByCode(Integer operationType) {
        for (MealClearOperationEnum type : values()) {
            if (type.getOperationType().equals(operationType)) {
                return type;
            }
        }
        return null;
    }

}
