package cn.freemud.client;

import cn.freemud.base.constant.Version;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.thirdparty.ActivityClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.assertEquals;
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ActivityClientTest {
    
    @Autowired
    private ActivityClient activityClient;
    private final static String application = "isaas";
    
    @Test
    public void queryTest() {
        ActivityQueryResponseDto activityQueryResponseDto = activityClient.query(ActivityQueryRequestDto.builder()
                .ver(Version.VERSION_1)
                .partnerCode("1864")
                .storeId("1")
                .activityType(ActivityTypeEnum.TYPE_81.getCode())
                .application(application)
                .build());
        System.out.println(activityQueryResponseDto);
    }

    @Test
    public void calculationDiscount() {
        
        ActivityCalculationDiscountRequestDto result = new ActivityCalculationDiscountRequestDto();
        result.setVer(Integer.valueOf(Version.VERSION_1));
        result.setPartnerCode("1864");
        result.setStoreId("1011");
        result.setChannel("wx3242134124");
        result.setIsShowActivities(1);
        result.setIsShowGoodsActivity(1);
        List<ActivityCalculationDiscountRequestDto.CalculationDiscountGoods> goods = new ArrayList<>();
        // TODO 暂时指定成一个商品，后期优化
        ActivityCalculationDiscountRequestDto.CalculationDiscountGoods calculationDiscountGoods = new ActivityCalculationDiscountRequestDto.CalculationDiscountGoods();
        calculationDiscountGoods.setGoodsId("1");
        calculationDiscountGoods.setCategory("1");
        calculationDiscountGoods.setGoodsQuantity(1);
        Long amount = 100L;
        Long couponAmount = 10L;
        Long packAmount = 0L;
        Long promotionAmount = 0L;
        calculationDiscountGoods.setOriginalPrice(amount + packAmount - couponAmount - promotionAmount);
        goods.add(calculationDiscountGoods);
        result.setGoods(goods);
        ActivityCalculationDiscountResponseDto activityCalculationDiscountResponseDto = activityClient.calculationDiscount(result);
        assertEquals(activityCalculationDiscountResponseDto.getStatusCode(), "100");
    }
    
    @Test
    public void repertoryCalculateTest() {
        
        ActivityUpdateStockRequestDto activityUpdateStockRequestDto = new ActivityUpdateStockRequestDto();
        activityUpdateStockRequestDto.setVer(Version.VERSION_1);
        activityUpdateStockRequestDto.setOrderId("1");
        activityUpdateStockRequestDto.setPartnerCode("1864");
        activityUpdateStockRequestDto.setStoreId("1001");
        List<ActivityUpdateStockRequestDto.StockBeanDto> stock = new ArrayList<>();
        ActivityUpdateStockRequestDto.StockBeanDto stockBeanDto = new ActivityUpdateStockRequestDto.StockBeanDto();
        stockBeanDto.setActivityCode("MEHG2018121311460590815");
        stockBeanDto.setActivityStock(1);
        List<ActivityUpdateStockRequestDto.StockBeanDto.GoodsStock> goodsStocks = new ArrayList<>();
        ActivityUpdateStockRequestDto.StockBeanDto.GoodsStock goodsStock = new ActivityUpdateStockRequestDto.StockBeanDto.GoodsStock();
        goodsStock.setGoodsId("124299127936858625");
        goodsStock.setStock(1);
        goodsStocks.add(goodsStock);
        stockBeanDto.setGoodsStock(goodsStocks);
        stock.add(stockBeanDto);
        activityUpdateStockRequestDto.setStock(stock);
        ActivityBaseResponseDto activityBaseResponseDto = activityClient.updateStock(activityUpdateStockRequestDto);
        System.out.println(activityBaseResponseDto);
        
        ActivityCancelStockRequestDto activityCancelStockRequestDto = new ActivityCancelStockRequestDto();
        activityCancelStockRequestDto.setVer(Version.VERSION_1);
        activityCancelStockRequestDto.setPartnerCode("1864");
        activityCancelStockRequestDto.setOrderId("1");
        ActivityBaseResponseDto cancelStock = activityClient.cancelStock(activityCancelStockRequestDto);
        System.out.println(cancelStock);
    }
}
