package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.QueryOrderVo;
import cn.freemud.entities.vo.WechatGroupBuyVo;
import cn.freemud.service.impl.CollageOrderServiceImpl;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CreateOrderController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping1.wu
 * @date: 2020/5/21 17:16
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RequestMapping("/order")
@RestController
@Validated
public class CollageOrderController {

    @Autowired
    private CollageOrderServiceImpl collageOrderService;

    @ApiOperation(value = "拼单订单提交", notes = "拼单订单提交")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CreateOrderVo", name = "CreateOrderVo")
    @ApiAnnotation(logMessage = "collageOrderCreate")
    @PostMapping(value = "/collage/create")
    public BaseResponse collageOrderCreate(@Validated @LogParams @RequestBody CreateOrderVo requestVo) {
        return collageOrderService.create(requestVo);
    }

    @ApiOperation(value = "获取拼单订单详情", notes = "获取拼单订单详情")
    @ApiImplicitParam(value = "请求", required = true, dataType = "QueryOrderVo", name = "QueryOrderVo")
    @ApiAnnotation(logMessage = "collageQueryOrderById")
    @PostMapping("/collage/queryOrderById")
    public BaseResponse queryCollageOrderById(@Validated @LogParams @RequestBody QueryOrderVo queryOrderVo) {
        return collageOrderService.queryCollageOrderById(queryOrderVo);
    }

    @ApiOperation(value = "拼单群收款详情", notes = "拼单群收款详情")
    @ApiImplicitParam(value = "请求", required = true, dataType = "WechatGroupBuyVo", name = "WechatGroupBuyVo")
    @ApiAnnotation(logMessage = "groupBuyDetail")
    @PostMapping(value = "/collage/groupBuyDetail")
    public BaseResponse groupBuyDetail(@Validated @LogParams @RequestBody WechatGroupBuyVo requestVo) {
        return collageOrderService.groupBuyDetail(requestVo);
    }

    @ApiOperation(value = "创建拼单群收款", notes = "创建拼单群收款")
    @ApiImplicitParam(value = "请求", required = true, dataType = "WechatGroupBuyVo", name = "WechatGroupBuyVo")
    @ApiAnnotation(logMessage = "createGroupBuy")
    @PostMapping(value = "/collage/groupBuy")
    public BaseResponse createGroupBuy(@Validated @LogParams @RequestBody WechatGroupBuyVo requestVo) {
        return collageOrderService.createGroupBuy(requestVo);
    }

}
