package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ActivityDiscountDto;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.vo.*;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.storecenter.request.vo.GetOrgTreeListRequest;
import com.freemud.card.sdk.comm.Finals;
import com.freemud.card.sdk.comm.SignUtil;
import com.freemud.card.sdk.vo.coupon.request.MemberAddCouponVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.service.thirdpart
 * @Description:
 * @author: biao.zhang
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class CouponServiceTest {

    @Autowired
    private CouponService couponService;

    @Autowired
    private CommonService commonService;

    @Test
    public void getCouponList() {
        //1617,1617，88600017957134272219
        String partnerId = "1617";
        String memberId = "1617";
        String code = "88600017957134272219";
        GetMemberCouponListRequestVo requestVo=new GetMemberCouponListRequestVo();
        requestVo.setPartnerId(partnerId);
        requestVo.setSessionId("5a9ec6c48d6c40d50e82f4f634ba1cd0f63b9dd5");
        requestVo.setPageNumber(1);
        requestVo.setPageSize(20);
        List list= Lists.newArrayList();
        list.add(0);
        requestVo.setStatusFlags(list);
        BaseResponse<GetMemberCouponListResponseVo> memberCoupon = couponService.getCouponList(requestVo);
        assertEquals(memberCoupon.getCode(), "100");
    }

    @Test
    public void addWeiXinCard() {
        AddWeiXinCardRequestVo addWeiXinCardRequestVo = new AddWeiXinCardRequestVo();
        addWeiXinCardRequestVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        addWeiXinCardRequestVo.setPartnerId("1864");
        addWeiXinCardRequestVo.setActivityCode("V24124124214124");
        addWeiXinCardRequestVo.setCouponCode("88123123213213");
        AddWeiXinCardResponseVo addWeiXinCardResponseVo = couponService.addWeiXinCard(addWeiXinCardRequestVo);
        assertTrue(CollectionUtils.isNotEmpty(addWeiXinCardResponseVo.getWeixinCardCodeListList()));
    }

    @Test
    public void getMemberCoupon() {
        GetMemberCouponRequestVo getMemberCouponRequestVo = new GetMemberCouponRequestVo();
        getMemberCouponRequestVo.setPartnerId("1864");
        getMemberCouponRequestVo.setSessionId("5d5f5d86d14df5b8a0e05b44e6239f39649daddd");
        getMemberCouponRequestVo.setCouponCode("881234124124142");
        GetCouponDetailResponseDto getCouponDetailResponseDto = couponService.getMemberCoupon(getMemberCouponRequestVo);
        assertEquals(getCouponDetailResponseDto.getStatusCode().toString(), "100");
    }

    @Test
    public void getMemberCoupons() {
        List<GetCouponDetailResponseDto.Details> details = couponService.getMemberCoupons("1864", "1001",Arrays.asList("8812412","88141242"));
        assertTrue(CollectionUtils.isNotEmpty(details));
    }

    @Test
    public void receiveMemberCoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "115450529962092328";
        String code = "88600017957134272219";
        ReceiveMemberCouponRequestVo requestVo=new ReceiveMemberCouponRequestVo();
        requestVo.setPartnerId(partnerId);
        requestVo.setMemberId(memberId);
        List<MemberAddCouponVo.Coupons> list= Lists.newArrayList();
        MemberAddCouponVo.Coupons couponList=new MemberAddCouponVo.Coupons();
        couponList.setCouponCode(code);
        couponList.setEncodeCouponCode("123");
        couponList.setCouponChannel("63");
        couponList.setActivityCode("C2412341233513255515");
        couponList.setPromotionCode("C2412341233513255515");
        couponList.setCouponName("活动名称");
        couponList.setCouponType("1");
        couponList.setStartTime("2019-02-26 12:12:12");
        couponList.setEndTime("2019-02-28 12:12:12");
        list.add(couponList);
        requestVo.setReceiveMemberCouponListList(list);
        BaseResponse memberCoupon = couponService.receiveMemberCoupon(requestVo);
        assertEquals(memberCoupon.getCode(), "100");
    }

    @Test
    public void availableCoupon() {
        List<CartGoods> cartGoods = Lists.newArrayList();
        CartGoods cartGood = new CartGoods();
        cartGoods.add(cartGood);
        ActivityClassifyCouponBean activityClassifyCouponBean = couponService.availableCoupon(cartGoods, "1864", "122424124", "1011", "88123124", true, 1, 1, "");
        assertTrue(activityClassifyCouponBean.getCouponNum() >= 1);
    }

    @Test
    public void getAppSecret() {
        String appSecret = couponService.getAppSecret("1864");
        assertTrue(StringUtils.isNotBlank(appSecret));
    }

    @Test
    public void checkSpqInfo() {
        CheckSpqInfoRequestDto checkSpqInfoRequestDto = new CheckSpqInfoRequestDto();
        checkSpqInfoRequestDto.setPartnerId("1864");
        checkSpqInfoRequestDto.setCouponCode("881231212334334");
        checkSpqInfoRequestDto.setStoreId("1011");
        CheckSpqInfoResponseDto checkSpqInfoResponseDto = couponService.checkSpqInfo(checkSpqInfoRequestDto);
        assertTrue(StringUtils.isNotBlank(checkSpqInfoResponseDto.getSkuId()));
    }

    @Test
    public void createCoupon() {
        List<ActivityDiscountDto> activityCodes = Lists.newArrayList();
        ActivityDiscountDto activityDiscountDto = new ActivityDiscountDto();
        activityDiscountDto.setCount(1);
        activityDiscountDto.setDiscountId("V234234342");
        activityCodes.add(activityDiscountDto);
        List<CreateCouponBeanVo> createCouponBeanVos = couponService.createCoupon(activityCodes, "1864", "1011", "13000000000", "1243124412");
        assertTrue(CollectionUtils.isNotEmpty(createCouponBeanVos));
    }

    @Test
    public void couponOrderWay() {
        Map<String, Boolean> couponOrderWayMap = couponService.couponOrderWay("1864", Arrays.asList("V1552905396926845"), 1);
        System.out.println(couponOrderWayMap);
    }

    /**
     * 批量券详情查询code_v4
     */
    @Test
    public void couponCodeV4() {
        GetMemberCouponRequestVo getMemberCouponRequestVo = new GetMemberCouponRequestVo();
        getMemberCouponRequestVo.setCouponCode("");
        getMemberCouponRequestVo.setPartnerId("");
        getMemberCouponRequestVo.setStoreId("");
        GetCouponDetailResponseDto responseDto = couponService.getMCCafeMemberCoupon(getMemberCouponRequestVo);
        System.out.println(JSON.toJSONString(responseDto));
    }

    @Test
    public String getAppSecret(String partner) {
        String appSecret = couponService.getMCCafeAppSecret(partner);
        System.out.println(appSecret);
        return appSecret;
    }



}
