package cn.freemud.demo.manager.store;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.demo.adapter.manager.StoreDTO2BOAdapter;
import cn.freemud.demo.entities.bo.goods.DeliveryConfigBO;
import cn.freemud.demo.entities.bo.store.GetStoreBO;
import cn.freemud.demo.entities.bo.store.GetStoreInfoBO;
import cn.freemud.demo.entities.bo.store.StoreInfoBO;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerStoreDeliveryConfig;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformPartnerStoreDeliveryConfigManager;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.request.vo.GetOrgTreeListRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("KgdStoreService")
public class KgdStoreServiceImpl implements StoreService {

    @Autowired
    private StoreCenterService storeCenterService;

    @Autowired
    private StoreDTO2BOAdapter storeDTO2BOAdapter;

    @Autowired
    private AssortmentOpenPlatformPartnerStoreDeliveryConfigManager deliveryConfigManager;

    @Override
    public List<String> getOrgIds(GetStoreBO getStoreBO) {

        GetOrgTreeListRequest request = new GetOrgTreeListRequest();
        request.setPartnerId(getStoreBO.getPartnerId());
        request.setStoreCode(getStoreBO.getStoreCode());
        BaseResponse<List<String>> orgList = storeCenterService.getOrgList(request, LogThreadLocal.getTrackingNo());
        if (orgList != null && ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(orgList.getCode())) {
            return orgList.getData();
        }
        return null;
    }

    @Override
    public StoreInfoBO getStoreInfo(GetStoreInfoBO getStoreInfo) {



        StoreInfoRequest request = new StoreInfoRequest();
        request.setPartnerId(getStoreInfo.getPartnerId());
        request.setStoreCode(getStoreInfo.getStoreId());
        //查询门店信息，获取门店经纬度
        StoreResponse storeResponse = storeCenterService.getStoreInfo(request, "");
        if (storeResponse == null || storeResponse.getStatusCode() != 100 || storeResponse.getBizVO() == null) {
            throw new ServiceException(ResponseResult.STORE_NOT_FOUND);
        }
        StoreInfoBO storeInfoBO = storeDTO2BOAdapter.convert2StoreInfoBO(storeResponse.getBizVO());
        return storeInfoBO;

    }

    @Override
    public DeliveryConfigBO findDeliveryConfigByPartnerIdAndStoreId(String partnerId, String storeId) {
        AssortmentOpenPlatformPartnerStoreDeliveryConfig deliveryConfig = deliveryConfigManager.findByPartnerIdAndStoreCode(partnerId, storeId);
        DeliveryConfigBO deliveryConfigBO = storeDTO2BOAdapter.convert2DeliveryConfigBO(deliveryConfig);
        return deliveryConfigBO;
    }
}
