package com.freemud.sdk.api.assortment.order.enums;

public enum QueryDeliveryType {

    SELF("self", "自配送"),
    THIRD("third", "第三方配送");
    private String code;

    private String desc;

    QueryDeliveryType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static QueryDeliveryType getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (QueryDeliveryType type : QueryDeliveryType.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
