/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/22 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class MaCafeQueryOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 订单ID
     */
    private String oid;
    /**
     * 订单状态 enum queryOrderStatus   全部订单 1 待取餐 2 已完成 3 全部   4.退款,5 待支付 ,6 已取消
     */
    private Integer queryOrderStatus;
    /**
     * 查询订单状态 1 外卖  4 门店自提
     */
    private Integer queryOrderType;
    /**
     *  每页显示几条数据
     */
    private Integer pageSize;
    /**
     * 第几页
     */
    private Integer pageNumber;

    private String startDate;

    private String endDate;

    /**
     * 渠道信息 saas; img; iwc; saasmall
     */
    private String channelType;

}
