package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.store.GetEstimateDeliveryRequest;
import cn.freemud.entities.dto.store.QueryDeliverDetailResponse;
import cn.freemud.entities.dto.store.StoreBaseResponseDto;
import cn.freemud.entities.dto.store.StoreInfoRequestDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/6/4 下午2:04
 * @description : 门店基础服务
 */
@FeignClient(name = "CONSOLE-API")
@RequestMapping(value = "/storecenter", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface StoreBaseApiClient {

    @PostMapping(value = "/storedelivery/v2/queryDeliverDetail")
    StoreBaseResponseDto<QueryDeliverDetailResponse> queryDeliverDetail(@RequestBody StoreInfoRequestDto request);
}
