/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PromotionActivityClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/6 11:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "PROMOTION-ACTIVITIES", url = "${saas.promotionactivityclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PromotionActivityClient {

    /**
     * 查询门店可参与的活动列表
     */
    @PostMapping("/activities/getActivitiesByStoreId")
    GetActivitiesResponseDto getActivitiesByStoreId(@RequestBody GetActivitiesDto getActivitiesDto);

    /**
     * 查询最近的一次进店有礼活动以及进店有礼领取验证
     * @param getActivitiesDto
     * @return
     */
    @PostMapping("/activities/enterGift/getActivitiesAndCheck")
    EnterGiftCheckResponseDto getActivitiesAndCheck(@RequestBody GetActivitiesDto getActivitiesDto);

    /**
     * 获取活动后的价格
     */
    @PostMapping("/activities/fullSubtraction/getPrice")
    BaseResponse getPromotionPrice(@RequestBody GetPromotionPriceDto getPromotionPriceDto);

    /**
     * 增加分享裂变活动的分享记录
     */
    @PostMapping("/activities/share/record")
    BaseResponse shareRecord(@RequestBody ShareAcitivityRequestDto createActivityRecordDto);

    /**
     * 增加参与活动记录
     */
    @PostMapping("/activities/addRecord")
    BaseResponse addRecord(@RequestBody CreateActivityRecordDto createActivityRecordDto);

    /**
     * 校验用户是否可以参与活动
     */
    @PostMapping("/activities/check")
    BaseResponse checkActivityValid(@RequestBody CheckActivityVaildDto checkActivityVaildDto);

    /**
     * 领券验证接口
     */
    @PostMapping("/activities/share/canReceive")
    BaseResponse canReceive(@RequestBody CanRecriveRequestDto checkActivityVaildDto);

    /**
     * 根据活动ID查询活动信息
     */
    @GetMapping("/activities/share/getById")
    ActivityGetByIdResponseDto getById(@RequestParam("activityId") Long activityId);

    /**
     * 查询分享页面领取的记录
     */
    @PostMapping("/activities/share/shareReceiveRecordList")
    ShareReceiveRecordlistResponseDto shareReceiveRecordList(ShareReceiveRecordListDto shareReceiveRecordListDto);

    /**
     * 进店有礼验证接口
     */
    @PostMapping("/activities/enterGift/check")
    EnterGiftCheckResponseDto enterGiftCheck(EnterGiftCheckDto enterGiftCheckDto);

    /**
     * 根据订单ID查询历史分享记录
     */
    @PostMapping("/activities/share/queryShareByOrderId")
    BaseResponse queryShareByOrderId(QueryShareByOrderIdDto queryShareByOrderIdDto);

    /**
     * 增加参与活动记录
     */
    @PostMapping("/activities/enterGift/entershopRecord")
    BaseResponse entershopRecord(@RequestBody EntershopRecordDto entershopRecordDto);

    /**
     * 获取活动id
     */
    @PostMapping("/activities/share/queryValidShareActivity")
    BaseResponse queryValidShareActivity(@RequestBody QueryValidShareActivityReq activityReq);

}
