package cn.freemud.entities.dto.store;

import lombok.Builder;
import lombok.Data;

import java.util.Date;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/6/4 下午3:42
 * @description :
 */
@Data
@Builder
public class QueryDeliverDetailResponse {
    /**
     * 每增加多少公里（单位米）
     */
    private String addRange;

    /**
     * 配送方式:1-三方物流配送、2-商家自配送
     */
    private String deliveryMethod;

    /**
     * 每增加距离增加多少钱（分）
     */
    private String addRangeAmount;

    /**
     * 配送区域名称
     */
    private String areaName;

    /**
     * 实际需要支付配送费
     */
    private Long deliveryAmount;

    /**
     * 配送费（分）
     */
    private String deliveryFee;

    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    private Integer deliveryFeeZeroReason;

    /**
     * 基础配送范围（单位米）
     */
    private String deliveryRange;

    /**
     * 配送时间（分钟）
     */
    private Integer deliveryTime;

    /**
     * 外卖起送条件（1:杯数，2:金额）
     */
    private Integer deliveryType;

    /**
     * 起送杯数
     */
    private Integer freeDeliveryCup;

    /**
     * 起送价格（分）
     */
    private String minOrderPrice;

    /**
     * 商户编号
     */
    private String partnerId;

    /**
     * 下单范围，格式：jsonArray，或者半径（米）
     */
    private String positionScope;

    /**
     * 下单范围类型 1手工画范围 2半径服务
     */
    private Integer positionScopeType;

    /**
     * 门店编号
     */
    private String storeCode;

    /**
     * 门店id
     */
    private String storeId;

    /**
     * 预计送达时间
     */
    private Date expectArriveTime;
}
