package cn.freemud.config;

import com.freemud.application.sdk.api.config.StockCenterProperties;
import com.freemud.application.sdk.api.membercenter.config.MemberCenterProperties;
import com.freemud.application.sdk.api.membercenter.config.MemberExtendProperties;
import com.freemud.application.sdk.api.membercenter.config.MemberPropertyProperties;
import com.freemud.application.sdk.api.membercenter.config.MemberScoreProperties;
import com.freemud.application.sdk.api.productcenter.config.InventoryCenterProperties;
import com.freemud.application.sdk.api.productcenter.config.ProductCenterProperties;
import com.freemud.application.sdk.api.storecenter.config.StoreCenterProperties;
import com.freemud.application.sdk.api.util.BaseRequestUtils;
import com.freemud.application.sdk.api.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Configuration
public class PreReleaseBeanConfig {



    @Profile({"pre-release"})
    @Bean(name = {"storeRestTemplate"})
    public RestTemplate proRestTemplateTemplate(@Autowired StoreCenterProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }


    @Profile({"pre-release"})
    @Bean(name = {"member.center"})
    public RestTemplate centerRestTemplateQa(@Qualifier("memberCenterProperties") MemberCenterProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"member.score"})
    public RestTemplate scoreRestTemplateQa(@Qualifier("mermberScoreProperties") MemberScoreProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"member.property"})
    public RestTemplate propertyRestTemplateQa(@Qualifier("memberPropertyProperties") MemberPropertyProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"member.extend"})
    public RestTemplate extendRestTemplateQa(@Qualifier("memberExtendProperties") MemberExtendProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"inventoryRestTemplate"})
    public RestTemplate inventoryRestTemplateQa(@Qualifier("inventoryCenterProperties") InventoryCenterProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"stockRestTemplate"})
    public RestTemplate stockRestTemplateQa(@Autowired StockCenterProperties stockCenterProperties) {
        Map<String, Integer> map = new HashMap(16);
        if (stockCenterProperties.getRetryTimes() != null) {
            map.put("retryTimes", stockCenterProperties.getRetryTimes());
        }

        if (stockCenterProperties.getConnectTimeOut() != null) {
            map.put("connectTimeOut", stockCenterProperties.getConnectTimeOut());
        }

        if (stockCenterProperties.getReadTimeOut() != null) {
            map.put("readTimeOut", stockCenterProperties.getReadTimeOut());
        }

        return RestTemplateUtils.getRestTemplateByType(map);
    }

    @Profile({"pre-release"})
    @Bean(name = {"productRestTemplate"})
    public RestTemplate productRestTemplate(@Autowired ProductCenterProperties productCenterProperties) {
        Map<String, Integer> map = new HashMap(16);
        if (productCenterProperties.getRetryTimes() != null) {
            map.put("retryTimes", productCenterProperties.getRetryTimes());
        }

        if (productCenterProperties.getConnectTimeOut() != null) {
            map.put("connectTimeOut", productCenterProperties.getConnectTimeOut());
        }

        if (productCenterProperties.getReadTimeOut() != null) {
            map.put("readTimeOut", productCenterProperties.getReadTimeOut());
        }

        return RestTemplateUtils.getRestTemplateByType(map);
    }

}
