package com.freemud.application.sdk.api.ordercenter.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/11/16 下午2:08
 * @description :  视频直播 场景值记录
 */
@AllArgsConstructor
@Getter
public enum CreateOrderSceneEnum {

    LIVE_STORE_ENTER("1175", "视频号主页商店入口"),
    LIVE_PRODUCT("1177", "视频号直播商品"),
    LIVE_HOME_PAGE_PRODUCT("1195", "视频号主页商品tab");

    private String scene;

    private String name;

    /**
     * 卖券订单需要校验的场景值
     */
    public static List<String> verifySceneOrder = Arrays.asList(CreateOrderSceneEnum.LIVE_STORE_ENTER.getScene(),
            CreateOrderSceneEnum.LIVE_PRODUCT.getScene(),
            CreateOrderSceneEnum.LIVE_HOME_PAGE_PRODUCT.getScene()
    );


}
