package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.entities.dto.user.*;
import com.freemud.application.sdk.api.membercenter.request.ReturnScoreRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "customer-property-service", url = "${customer.property.service.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerPropertyClient {


    @LogIgnoreFeign(logMessage="useScore")
    @PostMapping(value = "/propertyservice/score/pay")
    CustomerPropertyBaseResponse<PayScoreResponse> useScore(@RequestBody UseScoreRequest userScoreRequest);

    /**
     * 积分回退
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage = "returnScore")
    @PostMapping({"/propertyservice/score/returnScore"})
    CustomerPropertyBaseResponse returnScore(ReturnScoreRequest request);


    @LogIgnoreFeign(logMessage="statisticalScore")
    @PostMapping({"/propertyservice/score/statisticalScore"})
    CustomerPropertyBaseResponse<StatisticalScoreResponse> statisticalScore(StatisticalScoreRequestVo request);

    //查询用户储值卡或会员卡
    @LogIgnoreFeign(logMessage="getMemberCards")
    @PostMapping({"/propertyservice/card/getMemberCards"})
    CustomerPropertyBaseResponse<List<GetSvcInfoByMemberIdResponseVo>> getMemberCards(StatisticalScoreRequestVo request);

}
