package cn.freemud.consumer;

import cn.freemud.amp.EnumEmailAlert;
import cn.freemud.amp.body.OrderBody;
import cn.freemud.amp.constant.QueueMetadata;
import cn.freemud.amp.util.BodyConvertUtil;
import cn.freemud.amqp.MQMessage;
import cn.freemud.resposne.SynchronizationOrderResponse;
import cn.freemud.service.SynchronizedOrderService;
import cn.freemud.util.UUIDUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.service.EmailAlertService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/2/22 14:15
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
@Slf4j
public class SaobeiOrderFoodConsumer {
    private Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private EmailAlertService emailAlertService;
    @Autowired
    @Qualifier("saoBeiOrderFoodServiceImpl")
    private SynchronizedOrderService synchronizedOrderService;

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = QueueMetadata.SaobeiOrderFoodUpload.ORDERFOOD_QUEUE_NAME, durable = "true"),
            exchange = @Exchange(value = QueueMetadata.EXCHANGE_NAME, type = ExchangeTypes.TOPIC, durable = "true"), key = QueueMetadata.SaobeiOrderFoodUpload.ORDERFOOD_QUEUE_NAME_ROUTING_KEY),
            containerFactory = "rabbitListenerContainerFactory", admin = "rabbitAdmin")
    @RabbitHandler
    public void message(Message message) {
        OrderBody orderBody = null;
        MQMessage<OrderBody> mqMessage = BodyConvertUtil.orderJsonStringConvertToOrderBody(message);
        String traceId = UUIDUtil.getUUID();
        try {
            orderBody = mqMessage.getBody();
            log.info("saoBeiOrderFoodUpLoad result:{}", JSONObject.toJSONString(orderBody));
            if (null == orderBody) {
                return;
            }
            SynchronizationOrderResponse synchronizationOrderResponse = synchronizedOrderService.synchronizationOrder(traceId, orderBody,"","","","",1);
            if (!synchronizationOrderResponse.getResult()) {
                log.error("SaoBeiOrderFoodUpLoadConsumer mqHeader:{} body:{} 发送失败", null, JSONObject.toJSONString(orderBody));
            }
        } catch (JSONException ex) {
            logger.error("SaoBeiOrderFoodUpLoadConsumer  转换出错:{}", ExceptionUtils.getStackTrace(ex));
        } catch (Exception e) {
            emailAlertService.sendEmailAlert("扫呗点餐"+ EnumEmailAlert.Description.OrderPushError.getDescription(), JSON.toJSONString(orderBody));
            logger.error("SaoBeiOrderFoodUpLoadConsumer body:{} error:{}", JSONObject.toJSONString(orderBody), ExceptionUtils.getStackTrace(e));
            return;
        }
    }


}
