package com.freemud.application.sdk.api.ordercenter.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum PayChannelType {

    WECHAT((byte)1,"10211","微信"),
    SVC((byte)2,"10102","储值卡"),
    ALIPAY((byte)3,"10300","支付宝"),
    COMB((byte)4,"","混合支付"),
    USVCP((byte)5,"10556", "电子风味卡支付");



    private Byte index;
    private String ebcode;
    private String name;

    public static final String API_DESC = "订单支付渠道类型 1:微信 2:储值卡 3:支付宝 4:混合支付,5:电子风味卡支付";

    public static PayChannelType getByIndex(byte index) {
        for (PayChannelType payType : values()) {
            if (payType.getIndex().equals(index)) {
                return payType;
            }
        }
        return null;
    }
    public static PayChannelType getByEbcode(String ebcode) {
        for (PayChannelType payType : values()) {
            if (payType.getEbcode().equals(ebcode)) {
                return payType;
            }
        }
        return null;
    }
}
