package cn.freemud.amp.util;

import ch.qos.logback.classic.Level;
import cn.freemud.amp.body.OrderBody;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQMessage;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import sun.misc.BASE64Decoder;

@Slf4j
public class BodyConvertUtil {
    private static Gson gson = new Gson();

    public static MQMessage<OrderBody> orderJsonStringConvertToOrderBody(Message message) {
        MQMessage<OrderBody> mqMessage = new MQMessage<>();

        try {
            JSONObject jsonObject = (JSONObject) JSONObject.parse(message.getBody());
            Header header = JSON.parseObject(jsonObject.getJSONObject("header").toJSONString(), Header.class);
            OrderBody orderBody = gson.fromJson(jsonObject.getJSONObject("body").toJSONString(), OrderBody.class);
            mqMessage.setHeader(header);
            mqMessage.setBody(orderBody);
        } catch (Exception e) {
            log.error("参数转换失败：{}", e.getStackTrace());
        }

        return mqMessage;
    }


    public static MQMessage<OrderInfoReqs> orderJsonStringConvertToOrderInfoReqs(Message message, String traceId) throws Exception {
        MQMessage<OrderInfoReqs> mqMessage = new MQMessage<>();
        try {
            String byteBody = new String(message.getBody());
            JSONObject jsonObject = JSON.parseObject(byteBody);
            if (jsonObject.getJSONObject("header")!=null){
                Header header = JSON.parseObject(jsonObject.getJSONObject("header").toJSONString(), Header.class);
                mqMessage.setHeader(header);
            }
            OrderInfoReqs orderBody = gson.fromJson(jsonObject.getJSONObject("body").toJSONString(), OrderInfoReqs.class);
            mqMessage.setBody(orderBody);
        } catch (Exception e) {
            ErrorLog.printLog(SDKCommonBaseContextWare.getAppName(),traceId,BodyConvertUtil.class,"积分经验值转换出错:"+e.getMessage(),e, Level.ERROR);
            try {
                String byteBody = new String(message.getBody());
                final BASE64Decoder decoder = new BASE64Decoder();
                JSONObject jsonObject = (JSONObject) JSONObject.parse(decoder.decodeBuffer(byteBody));
                Header header = JSON.parseObject(jsonObject.getJSONObject("header").toJSONString(), Header.class);
                OrderInfoReqs orderBody = gson.fromJson(jsonObject.getJSONObject("body").toJSONString(), OrderInfoReqs.class);
                mqMessage.setHeader(header);
                mqMessage.setBody(orderBody);
            } catch (Exception e1) {
                ErrorLog.printLog(SDKCommonBaseContextWare.getAppName(),traceId,BodyConvertUtil.class,"积分经验值BASE64Decoder转换出错:"+e.getMessage(),e, Level.ERROR);
                throw e1;
            }
        }


        return mqMessage;
    }


}
