package cn.freemud.management.util;

import cn.freemud.base.constant.Version;
import cn.freemud.base.entity.BaseResponse;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class CommonResp<T> extends BaseResponse<T> {

    public CommonResp() {
        super();
    }

    public CommonResp(String ver, ResponseCodeEnum codeEnum) {
        super(ver, codeEnum.code, codeEnum.msg, (T) new JSONObject());
    }


    public CommonResp(String ver, ResponseCodeEnum codeEnum, T result) {
        super(ver, codeEnum.code, codeEnum.msg, result);
    }

    public CommonResp(ResponseCodeEnum codeEnum, T result) {
        super(Version.VERSION_1, codeEnum.code, codeEnum.msg, result);
    }

    public CommonResp(ResponseCodeEnum codeEnum) {
        super(Version.VERSION_1, codeEnum.code, codeEnum.msg, (T) new JSONObject());
    }

    public CommonResp(String code, String message) {
        super(Version.VERSION_1, code, message, (T) new JSONObject());
    }

    public static CommonResp success() {
        return new CommonResp(ResponseCodeEnum.SUCCESS);
    }

    public static CommonResp success(Object data) {
        return new CommonResp(ResponseCodeEnum.SUCCESS, data);
    }

    public static CommonResp fail() {
        return new CommonResp(ResponseCodeEnum.FAILURE);
    }

    public static CommonResp fail(Object data) {
        return new CommonResp(ResponseCodeEnum.FAILURE, data);
    }
}
