/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMemberInfoResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/5 17:26
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.List;

@NoArgsConstructor
@Data
@ToString
public class GetMemberInfoResponseDto {

    /**
     * code : 100
     * message :
     * result : {"account":"","birthday":"","channelList":[{"cardCode":"","cardTemplateId":"","channelCode":"dcxcx","channelType":"1","customerCardCode":"","registerCode":"","registerType":"2","thirdPartyCode":"ob0iP4nIyQrS9Ye-vgKOlsc2QGm8","unionId":""}],"city":"","district":"","email":"","idCard":"","memberId":"115282009388979639","memberName":"","mobile":"14170070313","nickName":"tommy风","partnerId":"360bb48b-5316-458a-903e-9a44c7f339b1","photoUrl":"","province":"","regionCode":"","remark1":"","sexFlag":"","sonBirthday":"","weddingDay":"","wifeBirthday":""}
     * ver : 1
     */

    private String code;
    private String message;
    private ResultBean result;
    private String ver;

    @NoArgsConstructor
    @Data
    public static class ResultBean {
        /**
         * account :
         * birthday :
         * channelList : [{"cardCode":"","cardTemplateId":"","channelCode":"dcxcx","channelType":"1","customerCardCode":"","registerCode":"","registerType":"2","thirdPartyCode":"ob0iP4nIyQrS9Ye-vgKOlsc2QGm8","unionId":""}]
         * city :
         * district :
         * email :
         * idCard :
         * memberId : 115282009388979639
         * memberName :
         * mobile : 14170070313
         * nickName : tommy风
         * partnerId : 360bb48b-5316-458a-903e-9a44c7f339b1
         * photoUrl :
         * province :
         * regionCode :
         * remark1 :
         * sexFlag :
         * sonBirthday :
         * weddingDay :
         * wifeBirthday :
         */

        private String account;
        private String birthday;
        private String city;
        private String district;
        private String email;
        private String idCard;
        private String memberId;
        private String memberName;
        private String mobile;
        private String nickName;
        private String partnerId;
        private String photoUrl;
        private String province;
        private String regionCode;
        private String remark1;
        private String sexFlag;
        private String sonBirthday;
        private String weddingDay;
        private String wifeBirthday;
        private List<ChannelListBean> channelList;

        @NoArgsConstructor
        @Data
        public static class ChannelListBean {
            /**
             * cardCode :
             * cardTemplateId :
             * channelCode : xcx
             * channelType : 1
             * customerCardCode :
             * registerCode :
             * registerType : 2
             * thirdPartyCode : ob0iP4nIyQrS9Ye-vgKOlsc2QGm8
             * unionId :
             */

            private String cardCode;
            private String cardTemplateId;
            private String channelCode;
            private String channelType;
            private String customerCardCode;
            private String registerCode;
            private String registerType;
            private String thirdPartyCode;
            private String unionId;
        }
    }
}
