/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.delivery;

import cn.freemud.base.util.DateUtil;
import cn.freemud.entities.ExtraDeliveryDto;
import cn.freemud.entities.dto.console.DeliveryInfoExpandFieldDTO;
import cn.freemud.entities.dto.console.NightDeliveryuInfo;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.utils.DateTimeUtil;
import lombok.SneakyThrows;
import org.apache.commons.collections4.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public interface DeliveryService {

    /**
     * 计算运费
     *
     * @param receiveId
     * @param partnerId
     * @param storeId
     * @param shoppingCartGoodsResponseVo
     * @return
     */
    Long calculateDeliveryAmount(String receiveId, String partnerId, String storeId, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo);

    Long calculateDeliveryAmount(String receiveId, String partnerId, String storeId);

    /**
     * 处理 额外配送费逻辑
     *
     * @param amount       原始配送费价格
     * @param expandFields 门店反馈的额外配送费配置
     */
    @SneakyThrows
    default List<ExtraDeliveryDto> nightDeliveryAmountHandle(long amount, DeliveryInfoExpandFieldDTO expandFields) {
        List<ExtraDeliveryDto> list = new ArrayList<>();
        if (amount > 0) {
            ExtraDeliveryDto defaultAmount = new ExtraDeliveryDto(ExtraDeliveryDto.TYPE_DEFAULT, amount);
            list.add(defaultAmount);
        }
        if (Objects.nonNull(expandFields) && CollectionUtils.isNotEmpty(expandFields.getNightDeliveryInfo())) {
            for (NightDeliveryuInfo info : expandFields.getNightDeliveryInfo()) {
                if (info.getStatus() == NightDeliveryuInfo.COMMON_STATUS_OPEN) {
                    // 当前时间在区间内
                    try {
                        Date nowTime = new SimpleDateFormat(DateUtil.FORMAT_time).parse(DateTimeUtil.getCurrentTimeStr());
                        Date startTime = new SimpleDateFormat(DateUtil.FORMAT_time).parse(info.getStartTime());
                        Date endTime = new SimpleDateFormat(DateUtil.FORMAT_time).parse(info.getEndTime());
                        if (DateTimeUtil.isEffectiveDate(nowTime, startTime, endTime)) {
                            ExtraDeliveryDto extraDeliveryDto = new ExtraDeliveryDto(info.getType(), info.getPrice());
                            list.add(extraDeliveryDto);
                            // 金额 增加, 原来配送费金额不变
//                            amount += info.getPrice();
                        }
                    } catch (ParseException e) {
                        // 报错表示 时间格式设置错误, 默认当做不计算
                        e.printStackTrace();
                    }

                }
            }
        }
        return list;
    }

}
